/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.where.DocKeys;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.WhereClauseOptimizer;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.Get;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.statistics.TableStats;
import java.util.Optional;

public final class RewriteCollectToGet
implements Rule<Collect> {
    private final Pattern<Collect> pattern = Pattern.typeOf(Collect.class).with(collect -> collect.relation() instanceof DocTableRelation && collect.where().hasQuery() && !Symbols.containsColumn(collect.outputs(), DocSysColumns.FETCHID));

    @Override
    public Pattern<Collect> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Collect collect, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        WhereClause where;
        DocTableRelation relation = (DocTableRelation)collect.relation();
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.CLUSTER, null, relation);
        WhereClauseOptimizer.DetailedQuery detailedQuery = WhereClauseOptimizer.optimize(normalizer, (where = collect.where()).queryOrFallback(), (DocTableInfo)relation.tableInfo(), txnCtx, nodeCtx);
        Optional<DocKeys> docKeys = detailedQuery.docKeys();
        if (docKeys.isPresent()) {
            return new Get(relation, docKeys.get(), detailedQuery.query(), collect.outputs(), tableStats.estimatedSizePerRow(relation.relationName()));
        }
        return null;
    }
}

