/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.OrderBy;
import io.crate.expression.symbol.FieldReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.Order;
import io.crate.planner.operators.Rename;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.statistics.TableStats;
import java.util.List;
import java.util.function.Function;

public final class MoveOrderBeneathRename
implements Rule<Order> {
    private final Capture<Rename> renameCapture = new Capture();
    private final Pattern<Order> pattern = Pattern.typeOf(Order.class).with(Patterns.source(), Pattern.typeOf(Rename.class).capturedAs(this.renameCapture));

    @Override
    public Pattern<Order> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Order plan, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        Rename rename = captures.get(this.renameCapture);
        Function<? super Symbol, ? extends Symbol> mapField = FieldReplacer.bind(rename::resolveField);
        OrderBy mappedOrderBy = plan.orderBy().map(mapField);
        if (rename.source().outputs().containsAll(mappedOrderBy.orderBySymbols())) {
            Order newOrder = new Order(rename.source(), mappedOrderBy);
            return rename.replaceSources(List.of(newOrder));
        }
        return null;
    }
}

