/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.OrderBy;
import io.crate.expression.symbol.FieldsVisitor;
import io.crate.expression.symbol.RefVisitor;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.NestedLoopJoin;
import io.crate.planner.operators.Order;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.statistics.TableStats;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class MoveOrderBeneathNestedLoop
implements Rule<Order> {
    private final Capture<NestedLoopJoin> nlCapture = new Capture();
    private final Pattern<Order> pattern = Pattern.typeOf(Order.class).with(Patterns.source(), Pattern.typeOf(NestedLoopJoin.class).capturedAs(this.nlCapture).with(nl -> !nl.joinType().isOuter()));

    @Override
    public Pattern<Order> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Order order, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        RelationName relationInOrderBy;
        NestedLoopJoin nestedLoop = captures.get(this.nlCapture);
        Set relationsInOrderBy = Collections.newSetFromMap(new IdentityHashMap());
        Consumer<ScopedSymbol> gatherRelationsFromField = f -> relationsInOrderBy.add(f.relation());
        Consumer<Reference> gatherRelationsFromRef = r -> relationsInOrderBy.add(r.ident().tableIdent());
        OrderBy orderBy = order.orderBy();
        for (Symbol orderExpr : orderBy.orderBySymbols()) {
            FieldsVisitor.visitFields(orderExpr, gatherRelationsFromField);
            RefVisitor.visitRefs(orderExpr, gatherRelationsFromRef);
        }
        if (relationsInOrderBy.size() == 1 && (relationInOrderBy = (RelationName)relationsInOrderBy.iterator().next()) == nestedLoop.topMostLeftRelation().relationName()) {
            LogicalPlan lhs = nestedLoop.sources().get(0);
            LogicalPlan newLhs = order.replaceSources(List.of(lhs));
            return new NestedLoopJoin(newLhs, nestedLoop.sources().get(1), nestedLoop.joinType(), nestedLoop.joinCondition(), nestedLoop.isFiltered(), nestedLoop.topMostLeftRelation(), true, nestedLoop.isRewriteFilterOnOuterJoinToInnerJoinDone());
        }
        return null;
    }
}

