/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WindowDefinition;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.WindowAgg;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.planner.optimizer.rule.Util;
import io.crate.statistics.TableStats;

public final class MoveFilterBeneathWindowAgg
implements Rule<Filter> {
    private final Capture<WindowAgg> windowAggCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(WindowAgg.class).capturedAs(this.windowAggCapture));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter plan, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        WindowAgg windowAgg = captures.get(this.windowAggCapture);
        WindowDefinition windowDefinition = windowAgg.windowDefinition();
        if (windowDefinition.partitions().containsAll(LogicalPlanner.extractColumns(plan.query()))) {
            return Util.transpose(plan, windowAgg);
        }
        return null;
    }
}

