/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.GroupHashAggregate;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.planner.optimizer.rule.Util;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.List;

public final class MoveFilterBeneathGroupBy
implements Rule<Filter> {
    private final Pattern<Filter> pattern;
    private final Capture<GroupHashAggregate> groupByCapture = new Capture();

    public MoveFilterBeneathGroupBy() {
        this.pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(GroupHashAggregate.class).capturedAs(this.groupByCapture));
    }

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol predicate = filter.query();
        List<Symbol> parts = AndOperator.split(predicate);
        ArrayList<Symbol> withAggregates = new ArrayList<Symbol>();
        ArrayList<Symbol> withoutAggregates = new ArrayList<Symbol>();
        for (Symbol part : parts) {
            if (SymbolVisitors.any(Symbols::isAggregate, part)) {
                withAggregates.add(part);
                continue;
            }
            withoutAggregates.add(part);
        }
        if (withoutAggregates.isEmpty()) {
            return null;
        }
        GroupHashAggregate groupBy = captures.get(this.groupByCapture);
        if (withoutAggregates.size() == parts.size()) {
            return Util.transpose(filter, groupBy);
        }
        LogicalPlan newGroupBy = groupBy.replaceSources(List.of(new Filter(groupBy.source(), AndOperator.join(withoutAggregates))));
        return new Filter(newGroupBy, AndOperator.join(withAggregates));
    }
}

