/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.planner.optimizer.rule.Util;
import io.crate.statistics.TableStats;
import java.util.List;

public final class MoveFilterBeneathFetchOrEval
implements Rule<Filter> {
    private final Capture<Eval> fetchOrEvalCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(Eval.class).capturedAs(this.fetchOrEvalCapture));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter plan, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        Eval eval = captures.get(this.fetchOrEvalCapture);
        List<Symbol> outputsOfFetchSource = eval.source().outputs();
        if (outputsOfFetchSource.containsAll(LogicalPlanner.extractColumns(plan.query()))) {
            return Util.transpose(plan, eval);
        }
        return null;
    }
}

