/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WhereClause;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.planner.selectivity.SelectivityFunctions;
import io.crate.statistics.Stats;
import io.crate.statistics.TableStats;

public class MergeFilterAndCollect
implements Rule<Filter> {
    private final Capture<Collect> collectCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(Collect.class).capturedAs(this.collectCapture));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        Collect collect = captures.get(this.collectCapture);
        Stats stats = tableStats.getStats(collect.relation().tableInfo().ident());
        WhereClause newWhere = collect.where().add(filter.query());
        return new Collect(collect.preferSourceLookup(), collect.relation(), collect.outputs(), newWhere, SelectivityFunctions.estimateNumRows(stats, newWhere.queryOrFallback(), null), stats.averageSizePerRowInBytes());
    }
}

