/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.common.collections.Lists2;
import io.crate.execution.engine.aggregation.impl.CountAggregation;
import io.crate.expression.symbol.Function;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.Count;
import io.crate.planner.operators.HashAggregate;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.statistics.TableStats;

public final class MergeAggregateAndCollectToCount
implements Rule<HashAggregate> {
    private final Capture<Collect> collectCapture = new Capture();
    private final Pattern<HashAggregate> pattern = Pattern.typeOf(HashAggregate.class).with(Patterns.source(), Pattern.typeOf(Collect.class).capturedAs(this.collectCapture).with(collect -> collect.relation().tableInfo() instanceof DocTableInfo)).with(aggregate -> aggregate.aggregates().size() == 1 && aggregate.aggregates().get(0).signature().equals(CountAggregation.COUNT_STAR_SIGNATURE));

    @Override
    public Pattern<HashAggregate> pattern() {
        return this.pattern;
    }

    public Count apply(HashAggregate aggregate, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        Collect collect = captures.get(this.collectCapture);
        Function countAggregate = Lists2.getOnlyElement(aggregate.aggregates());
        if (countAggregate.filter() != null) {
            return new Count(countAggregate, collect.relation(), collect.where().add(countAggregate.filter()));
        }
        return new Count(countAggregate, collect.relation(), collect.where());
    }
}

