/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class FilterOnJoinsUtil {
    private FilterOnJoinsUtil() {
    }

    static LogicalPlan getNewSource(@Nullable Symbol splitQuery, LogicalPlan source) {
        return splitQuery == null ? source : new Filter(source, splitQuery);
    }

    static LogicalPlan moveQueryBelowJoin(Symbol query, LogicalPlan join) {
        if (!WhereClause.canMatch(query)) {
            return join.replaceSources(List.of(FilterOnJoinsUtil.getNewSource(query, join.sources().get(0)), FilterOnJoinsUtil.getNewSource(query, join.sources().get(1))));
        }
        Map<Set<RelationName>, Symbol> splitQuery = QuerySplitter.split(query);
        int initialParts = splitQuery.size();
        if (splitQuery.size() == 1 && splitQuery.keySet().iterator().next().size() > 1) {
            return null;
        }
        assert (join.sources().size() == 2) : "Join operator must only have 2 children, LHS and RHS";
        LogicalPlan lhs = join.sources().get(0);
        LogicalPlan rhs = join.sources().get(1);
        Set<RelationName> leftName = lhs.getRelationNames();
        Set<RelationName> rightName = rhs.getRelationNames();
        Symbol queryForLhs = splitQuery.remove(leftName);
        Symbol queryForRhs = splitQuery.remove(rightName);
        LogicalPlan newLhs = FilterOnJoinsUtil.getNewSource(queryForLhs, lhs);
        LogicalPlan newRhs = FilterOnJoinsUtil.getNewSource(queryForRhs, rhs);
        LogicalPlan newJoin = join.replaceSources(List.of(newLhs, newRhs));
        if (splitQuery.isEmpty()) {
            return newJoin;
        }
        if (initialParts == splitQuery.size()) {
            return null;
        }
        return new Filter(newJoin, AndOperator.join(splitQuery.values()));
    }
}

