/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.matcher;

import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.matcher.Pattern;
import java.util.Optional;
import java.util.function.Function;

class WithPattern<T, U, V>
extends Pattern<T> {
    private final Pattern<T> firstPattern;
    private final Function<? super T, Optional<U>> getProperty;
    private final Pattern<V> propertyPattern;

    WithPattern(Pattern<T> firstPattern, Function<? super T, Optional<U>> getProperty, Pattern<V> propertyPattern) {
        this.firstPattern = firstPattern;
        this.getProperty = getProperty;
        this.propertyPattern = propertyPattern;
    }

    @Override
    public Match<T> accept(Object object, Captures captures) {
        Match<Object> match = this.firstPattern.accept(object, captures);
        return match.flatMap(matchedValue -> {
            Optional<Match> optProperty = this.getProperty.apply(matchedValue);
            Match<Object> propertyMatch = optProperty.map(property -> this.propertyPattern.accept(property, match.captures())).orElse(Match.empty());
            return propertyMatch.map(ignored -> match.value());
        });
    }
}

