/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.matcher;

import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.CapturePattern;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.matcher.TypeOfPattern;
import io.crate.planner.optimizer.matcher.WithPattern;
import io.crate.planner.optimizer.matcher.WithPropertyPattern;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class Pattern<T> {
    public static <T> Pattern<T> typeOf(Class<T> expectedClass) {
        return new TypeOfPattern<T>(expectedClass);
    }

    public <U, V> Pattern<T> with(Function<? super T, Optional<U>> getProperty, Pattern<V> propertyPattern) {
        return new WithPattern<T, U, V>(this, getProperty, propertyPattern);
    }

    public Pattern<T> with(Predicate<? super T> propertyPredicate) {
        return new WithPropertyPattern<T>(this, propertyPredicate);
    }

    public Pattern<T> capturedAs(Capture<T> capture) {
        return new CapturePattern<T>(capture, this);
    }

    public abstract Match<T> accept(Object var1, Captures var2);
}

