/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.matcher;

import io.crate.planner.optimizer.matcher.Captures;
import java.util.NoSuchElementException;
import java.util.function.Function;

public abstract class Match<T> {
    public static <T> Match<T> of(T value, Captures captures) {
        return new Present<T>(value, captures);
    }

    public static <T> Match<T> empty() {
        return Empty.INSTANCE;
    }

    public abstract Captures captures();

    public abstract boolean isPresent();

    public abstract T value();

    public abstract <U> Match<U> map(Function<? super T, ? extends U> var1);

    public abstract <U> Match<U> flatMap(Function<? super T, Match<U>> var1);

    static class Present<T>
    extends Match<T> {
        private final T value;
        private final Captures captures;

        Present(T value, Captures captures) {
            this.value = value;
            this.captures = captures;
        }

        @Override
        public Captures captures() {
            return this.captures;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public <U> Match<U> map(Function<? super T, ? extends U> mapper) {
            return Match.of(mapper.apply(this.value), this.captures);
        }

        @Override
        public <U> Match<U> flatMap(Function<? super T, Match<U>> mapper) {
            return mapper.apply(this.value);
        }
    }

    static class Empty<T>
    extends Match<T> {
        static final Empty INSTANCE = new Empty();

        Empty() {
        }

        @Override
        public Captures captures() {
            return Captures.empty();
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public T value() {
            throw new NoSuchElementException("Empty match contains no value");
        }

        @Override
        public <U> Match<U> map(Function<? super T, ? extends U> mapper) {
            return Empty.empty();
        }

        @Override
        public <U> Match<U> flatMap(Function<? super T, Match<U>> mapper) {
            return Empty.empty();
        }
    }
}

