/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer;

import com.google.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;

public class Optimizer {
    private static final Logger LOGGER = LogManager.getLogger(Optimizer.class);
    private final List<Rule<?>> rules;
    private final Supplier<Version> minNodeVersionInCluster;
    private final NodeContext nodeCtx;

    public Optimizer(NodeContext nodeCtx, Supplier<Version> minNodeVersionInCluster, List<Rule<?>> rules) {
        this.rules = rules;
        this.minNodeVersionInCluster = minNodeVersionInCluster;
        this.nodeCtx = nodeCtx;
    }

    public LogicalPlan optimize(LogicalPlan plan, TableStats tableStats, TransactionContext txnCtx) {
        List<Rule<?>> applicableRules;
        LogicalPlan optimizedRoot = this.tryApplyRules(applicableRules = Optimizer.removeExcludedRules(this.rules, txnCtx.sessionSettings().excludedOptimizerRules()), plan, tableStats, txnCtx);
        List<LogicalPlan> optimizedSources = Lists2.mapIfChange(optimizedRoot.sources(), x -> this.optimize((LogicalPlan)x, tableStats, txnCtx));
        return this.tryApplyRules(applicableRules, optimizedSources == optimizedRoot.sources() ? optimizedRoot : optimizedRoot.replaceSources(optimizedSources), tableStats, txnCtx);
    }

    @VisibleForTesting
    static List<Rule<?>> removeExcludedRules(List<Rule<?>> rules, Set<Class<? extends Rule<?>>> excludedRules) {
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        if (excludedRules.isEmpty()) {
            return rules;
        }
        ArrayList result = new ArrayList(rules.size());
        for (Rule<?> rule : rules) {
            if (excludedRules.contains(rule.getClass())) {
                if (!isTraceEnabled) continue;
                LOGGER.trace("Rule '" + rule.getClass().getSimpleName() + "' excluded from execution");
                continue;
            }
            result.add(rule);
        }
        return result;
    }

    private LogicalPlan tryApplyRules(List<Rule<?>> rules, LogicalPlan plan, TableStats tableStats, TransactionContext txnCtx) {
        int numIterations;
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        LogicalPlan node = plan;
        boolean done = false;
        for (numIterations = 0; !done && numIterations < 10000; ++numIterations) {
            done = true;
            Version minVersion = this.minNodeVersionInCluster.get();
            for (Rule<?> rule : rules) {
                LogicalPlan transformedPlan;
                Match<?> match;
                if (minVersion.before(rule.requiredVersion()) || !(match = rule.pattern().accept(node, Captures.empty())).isPresent()) continue;
                if (isTraceEnabled) {
                    LOGGER.trace("Rule '" + rule.getClass().getSimpleName() + "' matched");
                }
                if ((transformedPlan = rule.apply(match.value(), match.captures(), tableStats, txnCtx, this.nodeCtx)) == null) continue;
                if (isTraceEnabled) {
                    LOGGER.trace("Rule '" + rule.getClass().getSimpleName() + "' transformed the logical plan");
                }
                node = transformedPlan;
                done = false;
            }
        }
        assert (numIterations < 10000) : "Optimizer reached 10_000 iterations safety guard. This is an indication of a broken rule that matches again and again";
        return node;
    }
}

