/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer;

import com.google.common.base.CaseFormat;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingProvider;
import io.crate.planner.operators.RewriteInsertFromSubQueryToInsertFromValues;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.rule.DeduplicateOrder;
import io.crate.planner.optimizer.rule.MergeAggregateAndCollectToCount;
import io.crate.planner.optimizer.rule.MergeAggregateRenameAndCollectToCount;
import io.crate.planner.optimizer.rule.MergeFilterAndCollect;
import io.crate.planner.optimizer.rule.MergeFilters;
import io.crate.planner.optimizer.rule.MoveFilterBeneathFetchOrEval;
import io.crate.planner.optimizer.rule.MoveFilterBeneathGroupBy;
import io.crate.planner.optimizer.rule.MoveFilterBeneathHashJoin;
import io.crate.planner.optimizer.rule.MoveFilterBeneathNestedLoop;
import io.crate.planner.optimizer.rule.MoveFilterBeneathOrder;
import io.crate.planner.optimizer.rule.MoveFilterBeneathProjectSet;
import io.crate.planner.optimizer.rule.MoveFilterBeneathRename;
import io.crate.planner.optimizer.rule.MoveFilterBeneathUnion;
import io.crate.planner.optimizer.rule.MoveFilterBeneathWindowAgg;
import io.crate.planner.optimizer.rule.MoveOrderBeneathFetchOrEval;
import io.crate.planner.optimizer.rule.MoveOrderBeneathNestedLoop;
import io.crate.planner.optimizer.rule.MoveOrderBeneathRename;
import io.crate.planner.optimizer.rule.MoveOrderBeneathUnion;
import io.crate.planner.optimizer.rule.RemoveRedundantFetchOrEval;
import io.crate.planner.optimizer.rule.RewriteCollectToGet;
import io.crate.planner.optimizer.rule.RewriteFilterOnOuterJoinToInnerJoin;
import io.crate.planner.optimizer.rule.RewriteGroupByKeysLimitToTopNDistinct;
import io.crate.planner.optimizer.rule.RewriteToQueryThenFetch;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class LoadedRules
implements SessionSettingProvider {
    private static final String OPTIMIZER_SETTING_PREFIX = "optimizer_";
    private final List<Class<? extends Rule<?>>> rules = List.of(RemoveRedundantFetchOrEval.class, MergeAggregateAndCollectToCount.class, MergeAggregateRenameAndCollectToCount.class, MergeFilters.class, MoveFilterBeneathRename.class, MoveFilterBeneathFetchOrEval.class, MoveFilterBeneathOrder.class, MoveFilterBeneathProjectSet.class, MoveFilterBeneathHashJoin.class, MoveFilterBeneathNestedLoop.class, MoveFilterBeneathUnion.class, MoveFilterBeneathGroupBy.class, MoveFilterBeneathWindowAgg.class, MergeFilterAndCollect.class, RewriteFilterOnOuterJoinToInnerJoin.class, MoveOrderBeneathUnion.class, MoveOrderBeneathNestedLoop.class, MoveOrderBeneathFetchOrEval.class, MoveOrderBeneathRename.class, DeduplicateOrder.class, RewriteCollectToGet.class, RewriteGroupByKeysLimitToTopNDistinct.class, RewriteInsertFromSubQueryToInsertFromValues.class, RewriteToQueryThenFetch.class);

    @Override
    public List<SessionSetting<?>> sessionSettings() {
        return Lists2.map(this.rules, this::buildRuleSessionSetting);
    }

    @VisibleForTesting
    SessionSetting<?> buildRuleSessionSetting(Class<? extends Rule<?>> rule) {
        String simpleName = rule.getSimpleName();
        String optimizerRuleName = OPTIMIZER_SETTING_PREFIX + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, simpleName);
        return new SessionSetting<Boolean>(optimizerRuleName, objects -> {}, objects -> DataTypes.BOOLEAN.sanitizeValue(objects[0]), (sessionContext, activateRule) -> {
            if (activateRule.booleanValue()) {
                sessionContext.excludedOptimizerRules().remove(rule);
            } else {
                sessionContext.excludedOptimizerRules().add(rule);
            }
        }, s -> String.valueOf(!s.excludedOptimizerRules().contains(rule)), () -> String.valueOf(true), String.format(Locale.ENGLISH, "Indicates if the optimizer rule %s is activated.", simpleName), DataTypes.BOOLEAN);
    }
}

