/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.WindowDefinition;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.WindowAggProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.WindowFunction;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.distribution.DistributionType;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;

public class WindowAgg
extends ForwardingLogicalPlan {
    final WindowDefinition windowDefinition;
    private final List<WindowFunction> windowFunctions;
    private final List<Symbol> standalone;
    private final List<Symbol> outputs;

    static LogicalPlan create(LogicalPlan source, List<WindowFunction> windowFunctions) {
        ArrayList functions;
        if (windowFunctions.isEmpty()) {
            return source;
        }
        LinkedHashMap<WindowDefinition, ArrayList> groupedFunctions = new LinkedHashMap<WindowDefinition, ArrayList>();
        for (WindowFunction windowFunction : windowFunctions) {
            WindowDefinition windowDefinition = windowFunction.windowDefinition();
            functions = groupedFunctions.computeIfAbsent(windowDefinition, w -> new ArrayList());
            functions.add(windowFunction);
        }
        LogicalPlan lastWindowAgg = source;
        for (Map.Entry entry : groupedFunctions.entrySet()) {
            functions = (ArrayList)entry.getValue();
            WindowDefinition windowDefinition = (WindowDefinition)entry.getKey();
            OrderBy orderBy = windowDefinition.orderBy();
            if (orderBy == null || lastWindowAgg.outputs().containsAll(orderBy.orderBySymbols())) {
                lastWindowAgg = new WindowAgg(lastWindowAgg, windowDefinition, functions, lastWindowAgg.outputs());
                continue;
            }
            Eval eval = new Eval(lastWindowAgg, Lists2.concatUnique(lastWindowAgg.outputs(), orderBy.orderBySymbols()));
            lastWindowAgg = new WindowAgg(eval, windowDefinition, functions, eval.outputs());
        }
        return lastWindowAgg;
    }

    private WindowAgg(LogicalPlan source, WindowDefinition windowDefinition, List<WindowFunction> windowFunctions, List<Symbol> standalone) {
        super(source);
        this.outputs = Lists2.concat(standalone, windowFunctions);
        this.windowDefinition = windowDefinition;
        this.windowFunctions = windowFunctions;
        this.standalone = standalone;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        HashSet<Symbol> toKeep = new HashSet<Symbol>();
        ArrayList newWindowFunctions = new ArrayList();
        for (Symbol outputToKeep : outputsToKeep) {
            SymbolVisitors.intersection(outputToKeep, this.windowFunctions, newWindowFunctions::add);
            SymbolVisitors.intersection(outputToKeep, this.standalone, toKeep::add);
        }
        for (WindowFunction newWindowFunction : newWindowFunctions) {
            SymbolVisitors.intersection(newWindowFunction, this.source.outputs(), toKeep::add);
        }
        LogicalPlan newSource = this.source.pruneOutputsExcept(tableStats, toKeep);
        if (newSource == this.source) {
            return this;
        }
        return new WindowAgg(newSource, this.windowDefinition, List.copyOf(newWindowFunctions), newSource.outputs());
    }

    List<WindowFunction> windowFunctions() {
        return this.windowFunctions;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        boolean nonDistExecution;
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(this.source.outputs());
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        Function toInputCols = binder.andThen(s -> InputColumns.create(s, sourceSymbols));
        List<Symbol> boundWindowFunctions = Lists2.map(this.windowFunctions, toInputCols);
        ArrayList<Projection> projections = new ArrayList<Projection>();
        WindowAggProjection windowAggProjection = new WindowAggProjection(this.windowDefinition.map(toInputCols), boundWindowFunctions, InputColumns.create(this.standalone, sourceSymbols));
        projections.add(windowAggProjection);
        ExecutionPlan sourcePlan = this.source.build(plannerContext, projectionBuilder, -1, 0, null, pageSizeHint, params, subQueryResults);
        ResultDescription resultDescription = sourcePlan.resultDescription();
        boolean executesOnHandler = ExecutionPhases.executesOnHandler(plannerContext.handlerNode(), resultDescription.nodeIds());
        boolean bl = nonDistExecution = this.windowDefinition.partitions().isEmpty() || resultDescription.hasRemainingLimitOrOffset() || executesOnHandler;
        if (nonDistExecution) {
            sourcePlan = Merge.ensureOnHandler(sourcePlan, plannerContext);
            for (Projection projection : projections) {
                sourcePlan.addProjection(projection);
            }
        } else {
            sourcePlan.setDistributionInfo(new DistributionInfo(DistributionType.MODULO, this.source.outputs().indexOf(this.windowDefinition.partitions().iterator().next())));
            MergePhase distWindowAgg = new MergePhase(UUID.randomUUID(), plannerContext.nextExecutionPhaseId(), "distWindowAgg", resultDescription.nodeIds().size(), resultDescription.numOutputs(), resultDescription.nodeIds(), resultDescription.streamOutputs(), projections, DistributionInfo.DEFAULT_BROADCAST, null);
            return new Merge(sourcePlan, distWindowAgg, -1, 0, windowAggProjection.outputs().size(), resultDescription.maxRowsPerNode(), null);
        }
        return sourcePlan;
    }

    @Nullable
    static OrderBy createOrderByInclPartitionBy(WindowDefinition windowDefinition) {
        OrderBy orderBy = windowDefinition.orderBy();
        List<Symbol> partitions = windowDefinition.partitions();
        if (orderBy == null) {
            if (partitions.isEmpty()) {
                return null;
            }
            return new OrderBy(partitions);
        }
        return orderBy.prependUnique(partitions);
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitWindowAgg(this, context);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public WindowDefinition windowDefinition() {
        return this.windowDefinition;
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new WindowAgg(Lists2.getOnlyElement(sources), this.windowDefinition, this.windowFunctions, this.standalone);
    }

    public String toString() {
        return "WindowAgg{[" + Lists2.joinOn(", ", this.windowFunctions, Symbol::toString) + "]}";
    }
}

