/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.common.collections.Lists2;
import io.crate.common.collections.Maps;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.UnionExecutionPlan;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Union
implements LogicalPlan {
    private final List<Symbol> outputs;
    final LogicalPlan lhs;
    final LogicalPlan rhs;
    private final Map<LogicalPlan, SelectSymbol> dependencies;

    public Union(LogicalPlan lhs, LogicalPlan rhs, List<Symbol> outputs) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.outputs = outputs;
        this.dependencies = Maps.concat(lhs.dependencies(), rhs.dependencies());
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        Integer childPageSizeHint = limit != -1 ? Integer.valueOf(Limit.limitAndOffset(limit, offset)) : null;
        ExecutionPlan left = this.lhs.build(plannerContext, projectionBuilder, limit + offset, 0, null, childPageSizeHint, params, subQueryResults);
        ExecutionPlan right = this.rhs.build(plannerContext, projectionBuilder, limit + offset, 0, null, childPageSizeHint, params, subQueryResults);
        if (left.resultDescription().hasRemainingLimitOrOffset()) {
            left = Merge.ensureOnHandler(left, plannerContext);
        }
        if (right.resultDescription().hasRemainingLimitOrOffset()) {
            right = Merge.ensureOnHandler(right, plannerContext);
        }
        ResultDescription leftResultDesc = left.resultDescription();
        ResultDescription rightResultDesc = right.resultDescription();
        assert (DataTypes.isSameType(leftResultDesc.streamOutputs(), rightResultDesc.streamOutputs())) : "Left and right must output the same types, got lhs=" + leftResultDesc.streamOutputs() + ", rhs=" + rightResultDesc.streamOutputs();
        MergePhase mergePhase = new MergePhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), "union", leftResultDesc.nodeIds().size() + rightResultDesc.nodeIds().size(), 2, Collections.singletonList(plannerContext.handlerNode()), leftResultDesc.streamOutputs(), Collections.emptyList(), DistributionInfo.DEFAULT_BROADCAST, leftResultDesc.orderBy());
        return new UnionExecutionPlan(left, right, mergePhase, limit, offset, this.lhs.outputs().size(), -1, leftResultDesc.orderBy());
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return Lists2.concat(this.lhs.baseTables(), this.rhs.baseTables());
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of(this.lhs, this.rhs);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Union(sources.get(0), sources.get(1), this.outputs);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        IntArrayList outputIndicesToKeep = new IntArrayList();
        for (Symbol outputToKeep : outputsToKeep) {
            SymbolVisitors.intersection(outputToKeep, this.outputs, s -> {
                int idx = this.outputs.indexOf(s);
                assert (idx >= 0) : "outputs must contain symbol " + s + " if intersection called consumer";
                outputIndicesToKeep.add(idx);
            });
        }
        ArrayList<Symbol> toKeepFromLhs = new ArrayList<Symbol>();
        ArrayList<Symbol> toKeepFromRhs = new ArrayList<Symbol>();
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        for (IntCursor cursor : outputIndicesToKeep) {
            toKeepFromLhs.add(this.lhs.outputs().get(cursor.value));
            toKeepFromRhs.add(this.rhs.outputs().get(cursor.value));
            newOutputs.add(this.outputs.get(cursor.value));
        }
        LogicalPlan newLhs = this.lhs.pruneOutputsExcept(tableStats, toKeepFromLhs);
        LogicalPlan newRhs = this.rhs.pruneOutputsExcept(tableStats, toKeepFromRhs);
        if (newLhs == this.lhs && newRhs == this.rhs) {
            return this;
        }
        return new Union(newLhs, newRhs, newOutputs);
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return this.dependencies;
    }

    @Override
    public long numExpectedRows() {
        return this.lhs.numExpectedRows() + this.rhs.numExpectedRows();
    }

    @Override
    public long estimatedRowSize() {
        return Math.max(this.lhs.estimatedRowSize(), this.rhs.estimatedRowSize());
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitUnion(this, context);
    }
}

