/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.TopNDistinctProjection;
import io.crate.execution.dsl.projection.TopNProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class TopNDistinct
extends ForwardingLogicalPlan {
    private final Symbol limit;
    private final List<Symbol> outputs;
    private final Symbol offset;

    public TopNDistinct(LogicalPlan source, Symbol limit, Symbol offset, List<Symbol> outputs) {
        super(source);
        this.limit = limit;
        this.offset = offset;
        this.outputs = outputs;
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public Symbol limit() {
        return this.limit;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limitHint, int offsetHint, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan executionPlan = this.source.build(plannerContext, projectionBuilder, -1, 0, null, null, params, subQueryResults);
        if (executionPlan.resultDescription().hasRemainingLimitOrOffset()) {
            executionPlan = Merge.ensureOnHandler(executionPlan, plannerContext);
        }
        if (!this.source.outputs().equals(this.outputs)) {
            EvalProjection evalProjection = new EvalProjection(InputColumns.create(this.outputs, new InputColumns.SourceSymbols(this.source.outputs())));
            executionPlan.addProjection(evalProjection);
        }
        int limit = DataTypes.INTEGER.sanitizeValue(SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), this.limit, params, subQueryResults));
        int offset = DataTypes.INTEGER.sanitizeValue(SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), this.offset, params, subQueryResults));
        List<Symbol> inputColOutputs = InputColumn.mapToInputColumns(this.outputs);
        executionPlan.addProjection(new TopNDistinctProjection(limit + offset, inputColOutputs, this.source.preferShardProjections() ? RowGranularity.SHARD : RowGranularity.CLUSTER));
        boolean onHandler = ExecutionPhases.executesOnHandler(plannerContext.handlerNode(), executionPlan.resultDescription().nodeIds());
        if (!onHandler || this.source.preferShardProjections()) {
            if (!onHandler) {
                executionPlan = Merge.ensureOnHandler(executionPlan, plannerContext);
            }
            TopNDistinctProjection topNDistinct = new TopNDistinctProjection(limit + offset, inputColOutputs, RowGranularity.CLUSTER);
            executionPlan.addProjection(topNDistinct);
        }
        if (offset > 0) {
            executionPlan.addProjection(new TopNProjection(limit, offset, Symbols.typeView(inputColOutputs)));
        }
        return executionPlan;
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        LogicalPlan source = Lists2.getOnlyElement(sources);
        return new TopNDistinct(source, this.limit, this.offset, this.outputs);
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitTopNDistinct(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.source::print;
        printContext.text("TopNDistinct[").text(this.limit.toString()).text(";").text(this.offset.toString()).text(" | [").text(Lists2.joinOn(", ", this.outputs, Symbol::toString)).text("]]").nest(consumerArray);
    }
}

