/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.TableFunctionCollectPhase;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RowGranularity;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class TableFunction
implements LogicalPlan {
    private final TableFunctionRelation relation;
    private final List<Symbol> toCollect;
    final WhereClause where;

    public static LogicalPlan create(TableFunctionRelation relation, List<Symbol> toCollect, WhereClause where) {
        return new TableFunction(relation, toCollect, where);
    }

    public TableFunction(TableFunctionRelation relation, List<Symbol> toCollect, WhereClause where) {
        this.relation = relation;
        this.toCollect = toCollect;
        this.where = where;
    }

    public TableFunctionRelation relation() {
        return this.relation;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        List<Symbol> args = this.relation.function().arguments();
        ArrayList functionArguments = new ArrayList(args.size());
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(plannerContext.nodeContext(), RowGranularity.CLUSTER, null, this.relation);
        Function<Symbol, Symbol> binder = new SubQueryAndParamBinder(params, subQueryResults).andThen(x -> normalizer.normalize((Symbol)x, plannerContext.transactionContext()));
        for (Symbol arg : args) {
            functionArguments.add(Literal.ofUnchecked(arg.valueType(), SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), arg, params, subQueryResults)));
        }
        TableFunctionCollectPhase collectPhase = new TableFunctionCollectPhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), plannerContext.handlerNode(), this.relation.functionImplementation(), functionArguments, Lists2.map(this.toCollect, binder), binder.apply(this.where.queryOrFallback()));
        return new Collect(collectPhase, -1, 0, this.toCollect.size(), -1, null);
    }

    @Override
    public List<Symbol> outputs() {
        return this.toCollect;
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return List.of();
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        assert (sources.isEmpty()) : "TableFunction has no sources, cannot replace them";
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        if (outputsToKeep.containsAll(this.toCollect)) {
            return this;
        }
        return new TableFunction(this.relation, List.copyOf(outputsToKeep), this.where);
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    @Override
    public long numExpectedRows() {
        return -1L;
    }

    @Override
    public long estimatedRowSize() {
        return 0L;
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitTableFunction(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("TableFunction[").text(this.relation.function().name()).text(" | [").text(Lists2.joinOn(", ", this.toCollect, Symbol::toString)).text("] | ").text(this.where.queryOrFallback().toString()).text("]");
    }
}

