/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.data.Row;
import io.crate.expression.symbol.FunctionCopyVisitor;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Locale;
import java.util.function.Function;

public class SubQueryAndParamBinder
extends FunctionCopyVisitor<Void>
implements Function<Symbol, Symbol> {
    private final Row params;
    private final SubQueryResults subQueryResults;

    public static Symbol convert(Symbol symbol, Row params, SubQueryResults subQueryResults) {
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        return binder.apply(symbol);
    }

    public SubQueryAndParamBinder(Row params, SubQueryResults subQueryResults) {
        this.params = params;
        this.subQueryResults = subQueryResults;
    }

    @Override
    public Symbol visitParameterSymbol(ParameterSymbol parameterSymbol, Void context) {
        return SubQueryAndParamBinder.convert(parameterSymbol, this.params);
    }

    @Override
    public Symbol visitSelectSymbol(SelectSymbol selectSymbol, Void context) {
        Object value = this.subQueryResults.getSafe(selectSymbol);
        return Literal.ofUnchecked(selectSymbol.valueType(), selectSymbol.valueType().sanitizeValue(value));
    }

    @Override
    public Symbol apply(Symbol symbol) {
        return symbol.accept(this, null);
    }

    private static Symbol convert(ParameterSymbol parameterSymbol, Row params) {
        Object value;
        DataType<?> type = parameterSymbol.valueType();
        try {
            value = params.get(parameterSymbol.index());
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The query contains a parameter placeholder $%d, but there are only %d parameter values", parameterSymbol.index() + 1, params.numColumns()));
        }
        if (type.equals(DataTypes.UNDEFINED)) {
            type = DataTypes.guessType(value);
        }
        return Literal.ofUnchecked(type, type.implicitCast(value));
    }
}

