/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.Insert;
import io.crate.planner.operators.InsertFromValues;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.TableFunction;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.statistics.TableStats;

public class RewriteInsertFromSubQueryToInsertFromValues
implements Rule<Insert> {
    private final Capture<TableFunction> capture = new Capture();
    private final Pattern<Insert> pattern = Pattern.typeOf(Insert.class).with(Patterns.source(), Pattern.typeOf(TableFunction.class).capturedAs(this.capture));

    @Override
    public Pattern<Insert> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Insert plan, Captures captures, TableStats tableStats, TransactionContext txnCtx, NodeContext nodeCtx) {
        TableFunction tableFunction = captures.get(this.capture);
        TableFunctionRelation relation = tableFunction.relation();
        if (relation.function().name().equals("_values")) {
            return new InsertFromValues(tableFunction.relation(), plan.columnIndexWriterProjection());
        }
        return null;
    }
}

