/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.FieldResolver;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.metadata.RelationName;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.MapBackedSymbolReplacer;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class Rename
extends ForwardingLogicalPlan
implements FieldResolver {
    private final List<Symbol> outputs;
    private final FieldResolver fieldResolver;
    final RelationName name;

    public Rename(List<Symbol> outputs, RelationName name, FieldResolver fieldResolver, LogicalPlan source) {
        super(source);
        this.outputs = outputs;
        this.name = name;
        this.fieldResolver = fieldResolver;
        assert (this.outputs.size() == source.outputs().size()) : "Rename operator must have the same number of outputs as the source. Got " + outputs + " and " + source.outputs();
    }

    public RelationName name() {
        return this.name;
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        IdentityHashMap<Symbol, Symbol> parentToChildMap = new IdentityHashMap<Symbol, Symbol>(this.outputs.size());
        IdentityHashMap<Symbol, Symbol> childToParentMap = new IdentityHashMap<Symbol, Symbol>(this.outputs.size());
        for (int i = 0; i < this.outputs.size(); ++i) {
            parentToChildMap.put(this.outputs.get(i), this.source.outputs().get(i));
            childToParentMap.put(this.source.outputs().get(i), this.outputs.get(i));
        }
        ArrayList<Symbol> mappedToKeep = new ArrayList<Symbol>();
        for (Symbol outputToKeep : outputsToKeep) {
            SymbolVisitors.intersection(outputToKeep, this.outputs, s -> {
                Symbol childSymbol = (Symbol)parentToChildMap.get(s);
                assert (childSymbol != null) : "There must be a mapping available for symbol " + s;
                mappedToKeep.add(childSymbol);
            });
        }
        LogicalPlan newSource = this.source.pruneOutputsExcept(tableStats, mappedToKeep);
        if (newSource == this.source) {
            return this;
        }
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>(newSource.outputs().size());
        for (Symbol sourceOutput : newSource.outputs()) {
            newOutputs.add((Symbol)childToParentMap.get(sourceOutput));
        }
        return new Rename(newOutputs, this.name, this.fieldResolver, newSource);
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(TableStats tableStats, Collection<Symbol> usedColumns) {
        IdentityHashMap<Symbol, Symbol> parentToChildMap = new IdentityHashMap<Symbol, Symbol>(this.outputs.size());
        IdentityHashMap<Symbol, Symbol> childToParentMap = new IdentityHashMap<Symbol, Symbol>(this.outputs.size());
        for (int i = 0; i < this.outputs.size(); ++i) {
            parentToChildMap.put(this.outputs.get(i), this.source.outputs().get(i));
            childToParentMap.put(this.source.outputs().get(i), this.outputs.get(i));
        }
        ArrayList<Symbol> mappedUsedColumns = new ArrayList<Symbol>();
        for (Symbol usedColumn : usedColumns) {
            SymbolVisitors.intersection(usedColumn, this.outputs, s -> {
                Symbol childSymbol = (Symbol)parentToChildMap.get(s);
                assert (childSymbol != null) : "There must be a mapping available for symbol " + s;
                mappedUsedColumns.add(childSymbol);
            });
        }
        FetchRewrite fetchRewrite = this.source.rewriteToFetch(tableStats, mappedUsedColumns);
        if (fetchRewrite == null) {
            return null;
        }
        LogicalPlan newSource = fetchRewrite.newPlan();
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        for (Symbol output : newSource.outputs()) {
            if (output instanceof FetchMarker) {
                FetchMarker marker = (FetchMarker)output;
                FetchMarker newMarker = new FetchMarker(this.name, marker.fetchRefs(), marker.fetchId());
                newOutputs.add(newMarker);
                childToParentMap.put(marker, newMarker);
                continue;
            }
            Symbol mappedOutput = Objects.requireNonNull((Symbol)childToParentMap.get(output), () -> "Mapping must exist for output from source. `" + output + "` is missing in " + childToParentMap);
            newOutputs.add(mappedOutput);
        }
        LinkedHashMap<Symbol, Symbol> replacedOutputs = new LinkedHashMap<Symbol, Symbol>();
        Function<Symbol, Symbol> convertChildrenToScopedSymbols = s -> MapBackedSymbolReplacer.convert(s, childToParentMap);
        for (Map.Entry<Symbol, Symbol> entry : fetchRewrite.replacedOutputs().entrySet()) {
            Symbol key = entry.getKey();
            Symbol value = entry.getValue();
            Symbol parentSymbolForKey = Objects.requireNonNull((Symbol)childToParentMap.get(key), () -> "Mapping must exist for output from source. `" + key + "` is missing in " + childToParentMap);
            replacedOutputs.put(parentSymbolForKey, convertChildrenToScopedSymbols.apply(value));
        }
        Rename newRename = new Rename(newOutputs, this.name, this.fieldResolver, newSource);
        return new FetchRewrite(replacedOutputs, newRename);
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        return this.source.build(plannerContext, projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Rename(this.outputs, this.name, this.fieldResolver, Lists2.getOnlyElement(sources));
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitRename(this, context);
    }

    @Override
    @Nullable
    public Symbol resolveField(ScopedSymbol field) {
        return this.fieldResolver.resolveField(field);
    }

    @Override
    public Set<RelationName> getRelationNames() {
        return Set.of(this.name);
    }

    @Override
    public void print(PrintContext printContext) {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.source::print;
        printContext.text("Rename[").text(Lists2.joinOn(", ", this.outputs, Symbol::toString)).text("] AS ").text(this.name.toString()).nest(consumerArray);
    }

    public String toString() {
        return "Rename{name=" + this.name + ", outputs=" + this.outputs + ", src=" + this.source + "}";
    }
}

