/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.ProjectSetProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.metadata.FunctionType;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ProjectSet
extends ForwardingLogicalPlan {
    final List<Function> tableFunctions;
    final List<Symbol> standalone;
    private final List<Symbol> outputs;

    static LogicalPlan create(LogicalPlan source, List<Function> tableFunctions) {
        List childTableFunctions;
        if (tableFunctions.isEmpty()) {
            return source;
        }
        ArrayList<List<Function>> nestedFunctions = new ArrayList<List<Function>>();
        nestedFunctions.add(tableFunctions);
        while (!(childTableFunctions = tableFunctions.stream().flatMap(func -> func.arguments().stream()).filter(arg -> arg instanceof Function && ((Function)arg).type() == FunctionType.TABLE).map(x -> (Function)x).collect(Collectors.toList())).isEmpty()) {
            nestedFunctions.add(childTableFunctions);
            tableFunctions = childTableFunctions;
        }
        LogicalPlan result = source;
        for (int i = nestedFunctions.size() - 1; i >= 0; --i) {
            List<Symbol> standalone = result.outputs().stream().filter(x -> !(x instanceof Function) || ((Function)x).type() != FunctionType.TABLE).collect(Collectors.toList());
            result = new ProjectSet(result, (List)nestedFunctions.get(i), standalone);
        }
        return result;
    }

    private ProjectSet(LogicalPlan source, List<Function> tableFunctions, List<Symbol> standalone) {
        super(source);
        this.outputs = Lists2.concat(tableFunctions, standalone);
        this.tableFunctions = tableFunctions;
        this.standalone = standalone;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan sourcePlan = this.source.build(plannerContext, projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults);
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(this.source.outputs());
        List<Symbol> tableFunctionsWithInputs = InputColumns.create(this.tableFunctions, sourceSymbols);
        List<Symbol> standaloneWithInputs = InputColumns.create(this.standalone, sourceSymbols);
        sourcePlan.addProjection(new ProjectSetProjection(tableFunctionsWithInputs, standaloneWithInputs));
        return sourcePlan;
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public List<Symbol> standaloneOutputs() {
        return this.standalone;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        HashSet<Symbol> toKeep = new HashSet<Symbol>();
        LinkedHashSet newStandalone = new LinkedHashSet();
        LinkedHashSet newTableFunctions = new LinkedHashSet();
        for (Symbol outputToKeep : outputsToKeep) {
            SymbolVisitors.intersection(outputToKeep, this.standalone, newStandalone::add);
            SymbolVisitors.intersection(outputToKeep, this.tableFunctions, newTableFunctions::add);
        }
        for (Function newTableFunction : newTableFunctions) {
            SymbolVisitors.intersection(newTableFunction, this.source.outputs(), toKeep::add);
        }
        toKeep.addAll(newStandalone);
        LogicalPlan newSource = this.source.pruneOutputsExcept(tableStats, toKeep);
        if (newSource == this.source) {
            return this;
        }
        return new ProjectSet(newSource, List.copyOf(newTableFunctions), List.copyOf(newStandalone));
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new ProjectSet(Lists2.getOnlyElement(sources), this.tableFunctions, this.standalone);
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitProjectSet(this, context);
    }
}

