/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.common.collections.Lists2;
import io.crate.common.collections.Maps;
import io.crate.common.collections.Tuple;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.phases.NestedLoopPhase;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.execution.engine.join.JoinOperations;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.dql.join.Join;
import io.crate.planner.node.dql.join.JoinType;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class NestedLoopJoin
implements LogicalPlan {
    @Nullable
    private final Symbol joinCondition;
    private final AnalyzedRelation topMostLeftRelation;
    private final JoinType joinType;
    private final boolean isFiltered;
    final LogicalPlan lhs;
    final LogicalPlan rhs;
    private final List<Symbol> outputs;
    private final List<AbstractTableRelation<?>> baseTables;
    private final Map<LogicalPlan, SelectSymbol> dependencies;
    private boolean orderByWasPushedDown = false;
    private boolean rewriteFilterOnOuterJoinToInnerJoinDone = false;

    NestedLoopJoin(LogicalPlan lhs, LogicalPlan rhs, JoinType joinType, @Nullable Symbol joinCondition, boolean isFiltered, AnalyzedRelation topMostLeftRelation) {
        this.joinType = joinType;
        this.isFiltered = isFiltered || joinCondition != null;
        this.lhs = lhs;
        this.rhs = rhs;
        this.outputs = joinType == JoinType.SEMI ? lhs.outputs() : Lists2.concat(lhs.outputs(), rhs.outputs());
        this.baseTables = Lists2.concat(lhs.baseTables(), rhs.baseTables());
        this.topMostLeftRelation = topMostLeftRelation;
        this.joinCondition = joinCondition;
        this.dependencies = Maps.concat(lhs.dependencies(), rhs.dependencies());
    }

    public NestedLoopJoin(LogicalPlan lhs, LogicalPlan rhs, JoinType joinType, @Nullable Symbol joinCondition, boolean isFiltered, AnalyzedRelation topMostLeftRelation, boolean orderByWasPushedDown, boolean rewriteFilterOnOuterJoinToInnerJoinDone) {
        this(lhs, rhs, joinType, joinCondition, isFiltered, topMostLeftRelation);
        this.orderByWasPushedDown = orderByWasPushedDown;
        this.rewriteFilterOnOuterJoinToInnerJoinDone = rewriteFilterOnOuterJoinToInnerJoinDone;
    }

    public boolean isRewriteFilterOnOuterJoinToInnerJoinDone() {
        return this.rewriteFilterOnOuterJoinToInnerJoinDone;
    }

    public boolean isFiltered() {
        return true;
    }

    public AnalyzedRelation topMostLeftRelation() {
        return this.topMostLeftRelation;
    }

    public JoinType joinType() {
        return this.joinType;
    }

    @Nullable
    public Symbol joinCondition() {
        return this.joinCondition;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return this.dependencies;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        Integer childPageSizeHint = !this.isFiltered && limit != -1 ? Integer.valueOf(Limit.limitAndOffset(limit, offset)) : null;
        ExecutionPlan left = this.lhs.build(plannerContext, projectionBuilder, -1, 0, null, childPageSizeHint, params, subQueryResults);
        ExecutionPlan right = this.rhs.build(plannerContext, projectionBuilder, -1, 0, null, childPageSizeHint, params, subQueryResults);
        PositionalOrderBy orderByFromLeft = left.resultDescription().orderBy();
        boolean hasDocTables = this.baseTables.stream().anyMatch(r -> r instanceof DocTableRelation);
        boolean isDistributed = hasDocTables && this.isFiltered && !this.joinType.isOuter();
        LogicalPlan leftLogicalPlan = this.lhs;
        LogicalPlan rightLogicalPlan = this.rhs;
        isDistributed = isDistributed && !left.resultDescription().nodeIds().isEmpty() && !right.resultDescription().nodeIds().isEmpty();
        boolean blockNlPossible = !isDistributed && NestedLoopJoin.isBlockNlPossible(left, right);
        JoinType joinType = this.joinType;
        if (!this.orderByWasPushedDown && joinType.supportsInversion() && isDistributed && this.lhs.numExpectedRows() < this.rhs.numExpectedRows() && orderByFromLeft == null || blockNlPossible && this.lhs.numExpectedRows() > this.rhs.numExpectedRows()) {
            ExecutionPlan tmpExecutionPlan = left;
            left = right;
            right = tmpExecutionPlan;
            leftLogicalPlan = this.rhs;
            rightLogicalPlan = this.lhs;
            joinType = joinType.invert();
        }
        Tuple<Collection<String>, List<MergePhase>> joinExecutionNodesAndMergePhases = this.configureExecution(left, right, plannerContext, isDistributed);
        List<List<Symbol>> joinOutputs = Lists2.concat(leftLogicalPlan.outputs(), rightLogicalPlan.outputs());
        SubQueryAndParamBinder paramBinder = new SubQueryAndParamBinder(params, subQueryResults);
        Symbol joinInput = null;
        if (this.joinCondition != null) {
            joinInput = InputColumns.create(paramBinder.apply(this.joinCondition), joinOutputs);
        }
        NestedLoopPhase nlPhase = new NestedLoopPhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), isDistributed ? "distributed-nested-loop" : "nested-loop", Collections.singletonList(JoinOperations.createJoinProjection(this.outputs, joinOutputs)), joinExecutionNodesAndMergePhases.v2().get(0), joinExecutionNodesAndMergePhases.v2().get(1), leftLogicalPlan.outputs().size(), rightLogicalPlan.outputs().size(), joinExecutionNodesAndMergePhases.v1(), joinType, joinInput, Symbols.typeView(leftLogicalPlan.outputs()), leftLogicalPlan.estimatedRowSize(), leftLogicalPlan.numExpectedRows(), blockNlPossible);
        return new Join(nlPhase, left, right, -1, 0, -1, this.outputs.size(), orderByFromLeft);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return this.baseTables;
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of(this.lhs, this.rhs);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new NestedLoopJoin(sources.get(0), sources.get(1), this.joinType, this.joinCondition, this.isFiltered, this.topMostLeftRelation, this.orderByWasPushedDown, this.rewriteFilterOnOuterJoinToInnerJoinDone);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        LinkedHashSet<Symbol> lhsToKeep = new LinkedHashSet<Symbol>();
        LinkedHashSet<Symbol> rhsToKeep = new LinkedHashSet<Symbol>();
        for (Symbol outputToKeep : outputsToKeep) {
            SymbolVisitors.intersection(outputToKeep, this.lhs.outputs(), lhsToKeep::add);
            SymbolVisitors.intersection(outputToKeep, this.rhs.outputs(), rhsToKeep::add);
        }
        if (this.joinCondition != null) {
            SymbolVisitors.intersection(this.joinCondition, this.lhs.outputs(), lhsToKeep::add);
            SymbolVisitors.intersection(this.joinCondition, this.rhs.outputs(), rhsToKeep::add);
        }
        LogicalPlan newLhs = this.lhs.pruneOutputsExcept(tableStats, lhsToKeep);
        LogicalPlan newRhs = this.rhs.pruneOutputsExcept(tableStats, rhsToKeep);
        if (newLhs == this.lhs && newRhs == this.rhs) {
            return this;
        }
        return new NestedLoopJoin(newLhs, newRhs, this.joinType, this.joinCondition, this.isFiltered, this.topMostLeftRelation, this.orderByWasPushedDown, this.rewriteFilterOnOuterJoinToInnerJoinDone);
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(TableStats tableStats, Collection<Symbol> usedColumns) {
        FetchRewrite lhsFetchRewrite;
        LinkedHashSet<Symbol> usedFromLeft = new LinkedHashSet<Symbol>();
        LinkedHashSet<Symbol> usedFromRight = new LinkedHashSet<Symbol>();
        for (Symbol usedColumn : usedColumns) {
            SymbolVisitors.intersection(usedColumn, this.lhs.outputs(), usedFromLeft::add);
            SymbolVisitors.intersection(usedColumn, this.rhs.outputs(), usedFromRight::add);
        }
        if (this.joinCondition != null) {
            SymbolVisitors.intersection(this.joinCondition, this.lhs.outputs(), usedFromLeft::add);
            SymbolVisitors.intersection(this.joinCondition, this.rhs.outputs(), usedFromRight::add);
        }
        if ((lhsFetchRewrite = this.lhs.rewriteToFetch(tableStats, usedFromLeft)) == null) {
            return null;
        }
        FetchRewrite rhsFetchRewrite = this.rhs.rewriteToFetch(tableStats, usedFromRight);
        if (rhsFetchRewrite == null) {
            return null;
        }
        LinkedHashMap<Symbol, Symbol> allReplacedOutputs = new LinkedHashMap<Symbol, Symbol>(lhsFetchRewrite.replacedOutputs());
        allReplacedOutputs.putAll(rhsFetchRewrite.replacedOutputs());
        return new FetchRewrite(allReplacedOutputs, new NestedLoopJoin(lhsFetchRewrite.newPlan(), rhsFetchRewrite.newPlan(), this.joinType, this.joinCondition, this.isFiltered, this.topMostLeftRelation, this.orderByWasPushedDown, this.rewriteFilterOnOuterJoinToInnerJoinDone));
    }

    private Tuple<Collection<String>, List<MergePhase>> configureExecution(ExecutionPlan left, ExecutionPlan right, PlannerContext plannerContext, boolean isDistributed) {
        Collection<String> nlExecutionNodes = Set.of(plannerContext.handlerNode());
        ResultDescription leftResultDesc = left.resultDescription();
        ResultDescription rightResultDesc = right.resultDescription();
        MergePhase leftMerge = null;
        MergePhase rightMerge = null;
        if (leftResultDesc.nodeIds().size() == 1 && leftResultDesc.nodeIds().equals(rightResultDesc.nodeIds()) && !rightResultDesc.hasRemainingLimitOrOffset()) {
            nlExecutionNodes = leftResultDesc.nodeIds();
            left.setDistributionInfo(DistributionInfo.DEFAULT_SAME_NODE);
            right.setDistributionInfo(DistributionInfo.DEFAULT_SAME_NODE);
        } else if (isDistributed && !leftResultDesc.hasRemainingLimitOrOffset()) {
            nlExecutionNodes = leftResultDesc.nodeIds();
            left.setDistributionInfo(DistributionInfo.DEFAULT_SAME_NODE);
            right.setDistributionInfo(DistributionInfo.DEFAULT_BROADCAST);
            rightMerge = JoinOperations.buildMergePhaseForJoin(plannerContext, rightResultDesc, nlExecutionNodes);
        } else {
            left.setDistributionInfo(DistributionInfo.DEFAULT_BROADCAST);
            right.setDistributionInfo(DistributionInfo.DEFAULT_BROADCAST);
            if (JoinOperations.isMergePhaseNeeded(nlExecutionNodes, leftResultDesc, false)) {
                leftMerge = JoinOperations.buildMergePhaseForJoin(plannerContext, leftResultDesc, nlExecutionNodes);
            }
            if (JoinOperations.isMergePhaseNeeded(nlExecutionNodes, rightResultDesc, false)) {
                rightMerge = JoinOperations.buildMergePhaseForJoin(plannerContext, rightResultDesc, nlExecutionNodes);
            }
        }
        return new Tuple<Collection<String>, List<MergePhase>>(nlExecutionNodes, Arrays.asList(leftMerge, rightMerge));
    }

    @Override
    public long numExpectedRows() {
        if (this.joinType == JoinType.CROSS) {
            return this.lhs.numExpectedRows() * this.rhs.numExpectedRows();
        }
        return Math.max(this.lhs.numExpectedRows(), this.rhs.numExpectedRows());
    }

    @Override
    public long estimatedRowSize() {
        return this.lhs.estimatedRowSize() + this.rhs.estimatedRowSize();
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitNestedLoopJoin(this, context);
    }

    private static boolean isBlockNlPossible(ExecutionPlan left, ExecutionPlan right) {
        return left.resultDescription().orderBy() == null && left.resultDescription().nodeIds().size() <= 1 && left.resultDescription().nodeIds().equals(right.resultDescription().nodeIds());
    }

    public boolean orderByWasPushedDown() {
        return this.orderByWasPushedDown;
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("NestedLoopJoin[").text(this.joinType.toString());
        if (this.joinCondition != null) {
            printContext.text(" | ").text(this.joinCondition.toString());
        }
        printContext.text("]").nest(Lists2.map(this.sources(), x -> x::print));
    }

    public String toString() {
        return "NestedLoopJoin{joinCondition=" + this.joinCondition + ", joinType=" + this.joinType + ", isFiltered=" + this.isFiltered + ", lhs=" + this.lhs + ", rhs=" + this.rhs + ", outputs=" + this.outputs + "}";
    }
}

