/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.SubqueryPlanner;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class MultiPhase
extends ForwardingLogicalPlan {
    private final Map<LogicalPlan, SelectSymbol> subQueries;

    public static LogicalPlan createIfNeeded(LogicalPlan source, AnalyzedRelation relation, SubqueryPlanner subqueryPlanner) {
        Map<LogicalPlan, SelectSymbol> subQueries = subqueryPlanner.planSubQueries(relation);
        if (subQueries.isEmpty()) {
            return source;
        }
        return new MultiPhase(source, subQueries);
    }

    private MultiPhase(LogicalPlan source, Map<LogicalPlan, SelectSymbol> subQueries) {
        super(source);
        HashMap<LogicalPlan, SelectSymbol> allSubQueries = new HashMap<LogicalPlan, SelectSymbol>(source.dependencies());
        allSubQueries.putAll(subQueries);
        this.subQueries = Collections.unmodifiableMap(allSubQueries);
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        return this.source.build(plannerContext, projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new MultiPhase(Lists2.getOnlyElement(sources), this.subQueries);
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return this.subQueries;
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitMultiPhase(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.source::print;
        printContext.text("MultiPhase").nest(consumerArray).nest(Lists2.map(this.subQueries.keySet(), x -> x::print));
    }
}

