/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.AnalyzedInsertStatement;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.OrderBy;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AliasedAnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.AnalyzedView;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.JoinPair;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.TableRelation;
import io.crate.analyze.relations.UnionSelect;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.MultiPhaseExecutor;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.projection.builder.SplitPoints;
import io.crate.execution.dsl.projection.builder.SplitPointsBuilder;
import io.crate.execution.engine.NodeOperationTreeGenerator;
import io.crate.expression.symbol.FieldReplacer;
import io.crate.expression.symbol.FieldsVisitor;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.RefVisitor;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.SubqueryPlanner;
import io.crate.planner.consumer.InsertFromSubQueryPlanner;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.Distinct;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.GroupHashAggregate;
import io.crate.planner.operators.HashAggregate;
import io.crate.planner.operators.JoinPlanBuilder;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.MultiPhase;
import io.crate.planner.operators.Order;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.ProjectSet;
import io.crate.planner.operators.Rename;
import io.crate.planner.operators.RewriteInsertFromSubQueryToInsertFromValues;
import io.crate.planner.operators.RootRelationBoundary;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.operators.TableFunction;
import io.crate.planner.operators.Union;
import io.crate.planner.operators.WindowAgg;
import io.crate.planner.optimizer.Optimizer;
import io.crate.planner.optimizer.rule.DeduplicateOrder;
import io.crate.planner.optimizer.rule.MergeAggregateAndCollectToCount;
import io.crate.planner.optimizer.rule.MergeAggregateRenameAndCollectToCount;
import io.crate.planner.optimizer.rule.MergeFilterAndCollect;
import io.crate.planner.optimizer.rule.MergeFilters;
import io.crate.planner.optimizer.rule.MoveFilterBeneathFetchOrEval;
import io.crate.planner.optimizer.rule.MoveFilterBeneathGroupBy;
import io.crate.planner.optimizer.rule.MoveFilterBeneathHashJoin;
import io.crate.planner.optimizer.rule.MoveFilterBeneathNestedLoop;
import io.crate.planner.optimizer.rule.MoveFilterBeneathOrder;
import io.crate.planner.optimizer.rule.MoveFilterBeneathProjectSet;
import io.crate.planner.optimizer.rule.MoveFilterBeneathRename;
import io.crate.planner.optimizer.rule.MoveFilterBeneathUnion;
import io.crate.planner.optimizer.rule.MoveFilterBeneathWindowAgg;
import io.crate.planner.optimizer.rule.MoveOrderBeneathFetchOrEval;
import io.crate.planner.optimizer.rule.MoveOrderBeneathNestedLoop;
import io.crate.planner.optimizer.rule.MoveOrderBeneathRename;
import io.crate.planner.optimizer.rule.MoveOrderBeneathUnion;
import io.crate.planner.optimizer.rule.RemoveRedundantFetchOrEval;
import io.crate.planner.optimizer.rule.RewriteCollectToGet;
import io.crate.planner.optimizer.rule.RewriteFilterOnOuterJoinToInnerJoin;
import io.crate.planner.optimizer.rule.RewriteGroupByKeysLimitToTopNDistinct;
import io.crate.planner.optimizer.rule.RewriteToQueryThenFetch;
import io.crate.statistics.TableStats;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.Version;

public class LogicalPlanner {
    public static final int NO_LIMIT = -1;
    private final Optimizer optimizer;
    private final TableStats tableStats;
    private final Visitor statementVisitor = new Visitor();
    private final Optimizer writeOptimizer;
    private final Optimizer fetchOptimizer;

    public LogicalPlanner(NodeContext nodeCtx, TableStats tableStats, Supplier<Version> minNodeVersionInCluster) {
        this.optimizer = new Optimizer(nodeCtx, minNodeVersionInCluster, List.of(new RemoveRedundantFetchOrEval(), new MergeAggregateAndCollectToCount(), new MergeAggregateRenameAndCollectToCount(), new MergeFilters(), new MoveFilterBeneathRename(), new MoveFilterBeneathFetchOrEval(), new MoveFilterBeneathOrder(), new MoveFilterBeneathProjectSet(), new MoveFilterBeneathHashJoin(), new MoveFilterBeneathNestedLoop(), new MoveFilterBeneathUnion(), new MoveFilterBeneathGroupBy(), new MoveFilterBeneathWindowAgg(), new MergeFilterAndCollect(), new RewriteFilterOnOuterJoinToInnerJoin(), new MoveOrderBeneathUnion(), new MoveOrderBeneathNestedLoop(), new MoveOrderBeneathFetchOrEval(), new MoveOrderBeneathRename(), new DeduplicateOrder(), new RewriteCollectToGet(), new RewriteGroupByKeysLimitToTopNDistinct()));
        this.fetchOptimizer = new Optimizer(nodeCtx, minNodeVersionInCluster, List.of(new RewriteToQueryThenFetch()));
        this.writeOptimizer = new Optimizer(nodeCtx, minNodeVersionInCluster, List.of(new RewriteInsertFromSubQueryToInsertFromValues()));
        this.tableStats = tableStats;
    }

    public LogicalPlan plan(AnalyzedStatement statement, PlannerContext plannerContext) {
        return statement.accept(this.statementVisitor, plannerContext);
    }

    public LogicalPlan planSubSelect(SelectSymbol selectSymbol, PlannerContext plannerContext) {
        Function<LogicalPlan, LogicalPlan> maybeApplySoftLimit;
        int fetchSize;
        CoordinatorTxnCtx txnCtx = plannerContext.transactionContext();
        AnalyzedRelation relation = selectSymbol.relation();
        if (selectSymbol.getResultType() == SelectSymbol.ResultType.SINGLE_COLUMN_SINGLE_VALUE) {
            fetchSize = 2;
            maybeApplySoftLimit = plan -> new Limit((LogicalPlan)plan, Literal.of(2L), Literal.of(0L));
        } else {
            fetchSize = 0;
            maybeApplySoftLimit = plan -> plan;
        }
        PlannerContext subSelectPlannerContext = PlannerContext.forSubPlan(plannerContext, fetchSize);
        SubqueryPlanner subqueryPlanner = new SubqueryPlanner(s -> this.planSubSelect((SelectSymbol)s, subSelectPlannerContext));
        PlanBuilder planBuilder = new PlanBuilder(subqueryPlanner, txnCtx, Set.of(), this.tableStats, subSelectPlannerContext.params());
        LogicalPlan plan2 = relation.accept(planBuilder, relation.outputs());
        plan2 = this.tryOptimizeForInSubquery(selectSymbol, relation, plan2);
        LogicalPlan optimizedPlan = this.optimizer.optimize(maybeApplySoftLimit.apply(plan2), this.tableStats, txnCtx);
        return new RootRelationBoundary(optimizedPlan);
    }

    private LogicalPlan tryOptimizeForInSubquery(SelectSymbol selectSymbol, AnalyzedRelation relation, LogicalPlan planBuilder) {
        if (selectSymbol.getResultType() == SelectSymbol.ResultType.SINGLE_COLUMN_MULTIPLE_VALUES && relation instanceof QueriedSelectRelation) {
            QueriedSelectRelation queriedRelation = (QueriedSelectRelation)relation;
            OrderBy relationOrderBy = queriedRelation.orderBy();
            Symbol firstOutput = queriedRelation.outputs().get(0);
            if ((relationOrderBy == null || !relationOrderBy.orderBySymbols().get(0).equals(firstOutput)) && DataTypes.isPrimitive(firstOutput.valueType())) {
                return Order.create(planBuilder, new OrderBy(Collections.singletonList(firstOutput)));
            }
        }
        return planBuilder;
    }

    public LogicalPlan plan(AnalyzedRelation relation, PlannerContext plannerContext, SubqueryPlanner subqueryPlanner, Set<PlanHint> hints) {
        CoordinatorTxnCtx coordinatorTxnCtx = plannerContext.transactionContext();
        PlanBuilder planBuilder = new PlanBuilder(subqueryPlanner, coordinatorTxnCtx, hints, this.tableStats, plannerContext.params());
        LogicalPlan logicalPlan = relation.accept(planBuilder, relation.outputs());
        LogicalPlan optimizedPlan = this.optimizer.optimize(logicalPlan, this.tableStats, coordinatorTxnCtx);
        assert (logicalPlan.outputs().equals(optimizedPlan.outputs())) : "Optimized plan must have the same outputs as original plan";
        LogicalPlan prunedPlan = optimizedPlan.pruneOutputsExcept(this.tableStats, relation.outputs());
        assert (logicalPlan.outputs().equals(optimizedPlan.outputs())) : "Pruned plan must have the same outputs as original plan";
        LogicalPlan fetchOptimized = this.fetchOptimizer.optimize(prunedPlan, this.tableStats, coordinatorTxnCtx);
        if (fetchOptimized != prunedPlan || hints.contains((Object)PlanHint.AVOID_TOP_LEVEL_FETCH)) {
            return fetchOptimized;
        }
        assert (logicalPlan.outputs().equals(fetchOptimized.outputs())) : "Fetch optimized plan must have the same outputs as original plan";
        return RewriteToQueryThenFetch.tryRewrite(relation, fetchOptimized, this.tableStats);
    }

    private static LogicalPlan groupByOrAggregate(LogicalPlan source, List<Symbol> groupKeys, List<io.crate.expression.symbol.Function> aggregates, TableStats tableStats) {
        if (!groupKeys.isEmpty()) {
            long numExpectedRows = GroupHashAggregate.approximateDistinctValues(source.numExpectedRows(), tableStats, groupKeys);
            return new GroupHashAggregate(source, groupKeys, aggregates, numExpectedRows);
        }
        if (!aggregates.isEmpty()) {
            return new HashAggregate(source, aggregates);
        }
        return source;
    }

    public static Set<Symbol> extractColumns(Symbol symbol) {
        LinkedHashSet<Symbol> columns = new LinkedHashSet<Symbol>();
        RefVisitor.visitRefs(symbol, columns::add);
        FieldsVisitor.visitFields(symbol, columns::add);
        return columns;
    }

    public static Set<Symbol> extractColumns(Collection<? extends Symbol> symbols) {
        LinkedHashSet<Symbol> columns = new LinkedHashSet<Symbol>();
        for (Symbol symbol : symbols) {
            RefVisitor.visitRefs(symbol, columns::add);
            FieldsVisitor.visitFields(symbol, columns::add);
        }
        return columns;
    }

    public static void execute(LogicalPlan logicalPlan, DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults, boolean enableProfiling) {
        if (logicalPlan.dependencies().isEmpty()) {
            LogicalPlanner.doExecute(logicalPlan, executor, plannerContext, consumer, params, subQueryResults, enableProfiling);
        } else {
            MultiPhaseExecutor.execute(logicalPlan.dependencies(), executor, plannerContext, params).whenComplete((valueBySubQuery, failure) -> {
                if (failure == null) {
                    LogicalPlanner.doExecute(logicalPlan, executor, plannerContext, consumer, params, valueBySubQuery, false);
                } else {
                    consumer.accept(null, (Throwable)failure);
                }
            });
        }
    }

    private static void doExecute(LogicalPlan logicalPlan, DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults, boolean enableProfiling) {
        NodeOperationTree nodeOpTree;
        try {
            nodeOpTree = LogicalPlanner.getNodeOperationTree(logicalPlan, dependencies, plannerContext, params, subQueryResults);
        }
        catch (Throwable t) {
            consumer.accept(null, t);
            return;
        }
        LogicalPlanner.executeNodeOpTree(dependencies, plannerContext.transactionContext(), plannerContext.jobId(), consumer, enableProfiling, nodeOpTree);
    }

    public static NodeOperationTree getNodeOperationTree(LogicalPlan logicalPlan, DependencyCarrier executor, PlannerContext plannerContext, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan executionPlan;
        try {
            executionPlan = logicalPlan.build(plannerContext, executor.projectionBuilder(), -1, 0, null, null, params, subQueryResults);
        }
        catch (Exception e) {
            PrintContext printContext = new PrintContext();
            logicalPlan.print(printContext);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format(Locale.ENGLISH, "Couldn't create execution plan from logical plan because of: %s:%n%s", e.getMessage(), printContext.toString()), e);
            illegalArgumentException.setStackTrace(e.getStackTrace());
            throw illegalArgumentException;
        }
        return NodeOperationTreeGenerator.fromPlan(executionPlan, executor.localNodeId());
    }

    public static void executeNodeOpTree(DependencyCarrier dependencies, TransactionContext txnCtx, UUID jobId, RowConsumer consumer, boolean enableProfiling, NodeOperationTree nodeOpTree) {
        dependencies.phasesTaskFactory().create(jobId, Collections.singletonList(nodeOpTree), enableProfiling).execute(consumer, txnCtx);
    }

    private class Visitor
    extends AnalyzedStatementVisitor<PlannerContext, LogicalPlan> {
        private Visitor() {
        }

        @Override
        protected LogicalPlan visitAnalyzedStatement(AnalyzedStatement analyzedStatement, PlannerContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot create LogicalPlan from AnalyzedStatement \"%s\"  - not supported.", analyzedStatement));
        }

        @Override
        public LogicalPlan visitSelectStatement(AnalyzedRelation relation, PlannerContext context) {
            SubqueryPlanner subqueryPlanner = new SubqueryPlanner(s -> LogicalPlanner.this.planSubSelect((SelectSymbol)s, context));
            LogicalPlan logicalPlan = LogicalPlanner.this.plan(relation, context, subqueryPlanner, Set.of());
            return new RootRelationBoundary(logicalPlan);
        }

        @Override
        protected LogicalPlan visitAnalyzedInsertStatement(AnalyzedInsertStatement statement, PlannerContext context) {
            SubqueryPlanner subqueryPlanner = new SubqueryPlanner(s -> LogicalPlanner.this.planSubSelect((SelectSymbol)s, context));
            return LogicalPlanner.this.writeOptimizer.optimize(InsertFromSubQueryPlanner.plan(statement, context, LogicalPlanner.this, subqueryPlanner), LogicalPlanner.this.tableStats, context.transactionContext());
        }
    }

    static class PlanBuilder
    extends AnalyzedRelationVisitor<List<Symbol>, LogicalPlan> {
        private final SubqueryPlanner subqueryPlanner;
        private final CoordinatorTxnCtx txnCtx;
        private final Set<PlanHint> hints;
        private final TableStats tableStats;
        private final Row params;

        private PlanBuilder(SubqueryPlanner subqueryPlanner, CoordinatorTxnCtx txnCtx, Set<PlanHint> hints, TableStats tableStats, Row params) {
            this.subqueryPlanner = subqueryPlanner;
            this.txnCtx = txnCtx;
            this.hints = hints;
            this.tableStats = tableStats;
            this.params = params;
        }

        @Override
        public LogicalPlan visitAnalyzedRelation(AnalyzedRelation relation, List<Symbol> outputs) {
            throw new UnsupportedOperationException(relation.getClass().getSimpleName() + " NYI");
        }

        @Override
        public LogicalPlan visitTableFunctionRelation(TableFunctionRelation relation, List<Symbol> outputs) {
            return MultiPhase.createIfNeeded(TableFunction.create(relation, relation.outputs(), WhereClause.MATCH_ALL), relation, this.subqueryPlanner);
        }

        @Override
        public LogicalPlan visitDocTableRelation(DocTableRelation relation, List<Symbol> outputs) {
            return Collect.create(relation, outputs, WhereClause.MATCH_ALL, this.hints, this.tableStats, this.params);
        }

        @Override
        public LogicalPlan visitTableRelation(TableRelation relation, List<Symbol> outputs) {
            return Collect.create(relation, outputs, WhereClause.MATCH_ALL, this.hints, this.tableStats, this.params);
        }

        @Override
        public LogicalPlan visitAliasedAnalyzedRelation(AliasedAnalyzedRelation relation, List<Symbol> outputs) {
            AnalyzedRelation child = relation.relation();
            if (child instanceof AbstractTableRelation) {
                List<? extends Symbol> mappedOutputs = Lists2.map(outputs, FieldReplacer.bind(relation::resolveField));
                LogicalPlan source = child.accept(this, mappedOutputs);
                return new Rename(outputs, relation.relationName(), relation, source);
            }
            LogicalPlan source = child.accept(this, child.outputs());
            return new Rename(relation.outputs(), relation.relationName(), relation, source);
        }

        @Override
        public LogicalPlan visitView(AnalyzedView view, List<Symbol> outputs) {
            AnalyzedRelation child = view.relation();
            LogicalPlan source = child.accept(this, child.outputs());
            return new Rename(view.outputs(), view.relationName(), view, source);
        }

        @Override
        public LogicalPlan visitUnionSelect(UnionSelect union, List<Symbol> outputs) {
            AnalyzedRelation lhsRel = union.left();
            AnalyzedRelation rhsRel = union.right();
            return new Union(lhsRel.accept(this, lhsRel.outputs()), rhsRel.accept(this, rhsRel.outputs()), union.outputs());
        }

        @Override
        public LogicalPlan visitQueriedSelectRelation(QueriedSelectRelation relation, List<Symbol> outputs) {
            SplitPoints splitPoints = SplitPointsBuilder.create(relation);
            LogicalPlan source = JoinPlanBuilder.buildJoinTree(relation.from(), relation.where(), relation.joinPairs(), rel -> {
                if (relation.from().size() == 1) {
                    return rel.accept(this, splitPoints.toCollect());
                }
                LinkedHashSet toCollect = new LinkedHashSet(splitPoints.toCollect().size());
                Consumer<Reference> addRefIfMatch = ref -> {
                    if (ref.ident().tableIdent().equals(rel.relationName())) {
                        toCollect.add(ref);
                    }
                };
                Consumer<ScopedSymbol> addFieldIfMatch = field -> {
                    if (field.relation().equals(rel.relationName())) {
                        toCollect.add(field);
                    }
                };
                for (Symbol symbol : splitPoints.toCollect()) {
                    RefVisitor.visitRefs(symbol, addRefIfMatch);
                    FieldsVisitor.visitFields(symbol, addFieldIfMatch);
                }
                FieldsVisitor.visitFields(relation.where(), addFieldIfMatch);
                RefVisitor.visitRefs(relation.where(), addRefIfMatch);
                for (JoinPair joinPair : relation.joinPairs()) {
                    Symbol condition = joinPair.condition();
                    if (condition == null) continue;
                    FieldsVisitor.visitFields(condition, addFieldIfMatch);
                    RefVisitor.visitRefs(condition, addRefIfMatch);
                }
                return rel.accept(this, List.copyOf(toCollect));
            }, this.txnCtx.sessionContext().isHashJoinEnabled());
            return MultiPhase.createIfNeeded(Eval.create(Limit.create(Order.create(Distinct.create(ProjectSet.create(WindowAgg.create(Filter.create(LogicalPlanner.groupByOrAggregate(ProjectSet.create(source, splitPoints.tableFunctionsBelowGroupBy()), relation.groupBy(), splitPoints.aggregates(), this.tableStats), relation.having()), splitPoints.windowFunctions()), splitPoints.tableFunctions()), relation.isDistinct(), relation.outputs(), this.tableStats), relation.orderBy()), relation.limit(), relation.offset()), outputs), relation, this.subqueryPlanner);
        }
    }
}

