/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface LogicalPlan
extends Plan {
    public ExecutionPlan build(PlannerContext var1, ProjectionBuilder var2, int var3, int var4, @Nullable OrderBy var5, @Nullable Integer var6, Row var7, SubQueryResults var8);

    public List<Symbol> outputs();

    default public boolean preferShardProjections() {
        return false;
    }

    public List<AbstractTableRelation<?>> baseTables();

    public List<LogicalPlan> sources();

    public LogicalPlan replaceSources(List<LogicalPlan> var1);

    public LogicalPlan pruneOutputsExcept(TableStats var1, Collection<Symbol> var2);

    @Nullable
    default public FetchRewrite rewriteToFetch(TableStats tableStats, Collection<Symbol> usedColumns) {
        return null;
    }

    public Map<LogicalPlan, SelectSymbol> dependencies();

    public long numExpectedRows();

    public long estimatedRowSize();

    @Override
    default public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        LogicalPlanner.execute(this, executor, plannerContext, consumer, params, subQueryResults, false);
    }

    public <C, R> R accept(LogicalPlanVisitor<C, R> var1, C var2);

    @Override
    default public Plan.StatementType type() {
        return Plan.StatementType.SELECT;
    }

    default public Set<RelationName> getRelationNames() {
        return this.baseTables().stream().map(AnalyzedRelation::relationName).collect(Collectors.toSet());
    }

    default public void print(PrintContext printContext) {
        printContext.text(this.getClass().getSimpleName()).text("[").text(Lists2.joinOn(", ", this.outputs(), Symbol::toString)).text("]").nest(Lists2.map(this.sources(), x -> x::print));
    }
}

