/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.JoinPair;
import io.crate.analyze.relations.QuerySplitter;
import io.crate.common.collections.Lists2;
import io.crate.execution.engine.join.JoinOperations;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.node.dql.join.JoinType;
import io.crate.planner.operators.EquiJoinDetector;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.HashJoin;
import io.crate.planner.operators.JoinOrdering;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.NestedLoopJoin;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.elasticsearch.common.util.set.Sets;

public class JoinPlanBuilder {
    static LogicalPlan buildJoinTree(List<AnalyzedRelation> from, Symbol whereClause, List<JoinPair> joinPairs, Function<AnalyzedRelation, LogicalPlan> plan, boolean hashJoinEnabled) {
        Symbol joinCondition;
        JoinType joinType;
        if (from.size() == 1) {
            return Filter.create(plan.apply(from.get(0)), whereClause);
        }
        Map<Set<RelationName>, Symbol> queryParts = QuerySplitter.split(whereClause);
        LinkedHashMap<Set<RelationName>, JoinPair> joinPairsByRelations = JoinOperations.buildRelationsToJoinPairsMap(JoinOperations.convertImplicitJoinConditionsToJoinPairs(joinPairs, queryParts));
        Collection<RelationName> orderedRelationNames = JoinOrdering.getOrderedRelationNames(Lists2.map(from, AnalyzedRelation::relationName), joinPairsByRelations.keySet(), queryParts.keySet());
        Iterator<RelationName> it = orderedRelationNames.iterator();
        RelationName lhsName = it.next();
        RelationName rhsName = it.next();
        HashSet<RelationName> joinNames = new HashSet<RelationName>();
        joinNames.add(lhsName);
        joinNames.add(rhsName);
        JoinPair joinLhsRhs = (JoinPair)joinPairsByRelations.remove(joinNames);
        if (joinLhsRhs == null) {
            joinType = JoinType.CROSS;
            joinCondition = null;
        } else {
            joinType = JoinPlanBuilder.maybeInvertPair(rhsName, joinLhsRhs);
            joinCondition = joinLhsRhs.condition();
        }
        Map<RelationName, AnalyzedRelation> sources = from.stream().collect(Collectors.toMap(AnalyzedRelation::relationName, rel -> rel));
        AnalyzedRelation lhs = sources.get(lhsName);
        AnalyzedRelation rhs = sources.get(rhsName);
        LogicalPlan lhsPlan = plan.apply(lhs);
        LogicalPlan rhsPlan = plan.apply(rhs);
        Symbol query = JoinPlanBuilder.removeParts(queryParts, lhsName, rhsName);
        LogicalPlan joinPlan = JoinPlanBuilder.createJoinPlan(lhsPlan, rhsPlan, joinType, joinCondition, lhs, rhs, query, hashJoinEnabled);
        joinPlan = Filter.create(joinPlan, query);
        while (it.hasNext()) {
            AnalyzedRelation nextRel = sources.get(it.next());
            joinPlan = JoinPlanBuilder.joinWithNext(plan, joinPlan, nextRel, joinNames, joinPairsByRelations, queryParts, lhs, hashJoinEnabled);
            joinNames.add(nextRel.relationName());
        }
        if (!queryParts.isEmpty()) {
            joinPlan = Filter.create(joinPlan, AndOperator.join(queryParts.values()));
            queryParts.clear();
        }
        assert (joinPairsByRelations.isEmpty()) : "Must've applied all joinPairs";
        return joinPlan;
    }

    private static LogicalPlan createJoinPlan(LogicalPlan lhsPlan, LogicalPlan rhsPlan, JoinType joinType, Symbol joinCondition, AnalyzedRelation lhs, AnalyzedRelation rhs, Symbol query, boolean hashJoinEnabled) {
        if (hashJoinEnabled && EquiJoinDetector.isHashJoinPossible(joinType, joinCondition)) {
            return new HashJoin(lhsPlan, rhsPlan, joinCondition, rhs);
        }
        return new NestedLoopJoin(lhsPlan, rhsPlan, joinType, joinCondition, !query.symbolType().isValueSymbol(), lhs);
    }

    private static JoinType maybeInvertPair(RelationName rhsName, JoinPair pair) {
        if (pair.right().equals(rhsName)) {
            return pair.joinType();
        }
        return pair.joinType().invert();
    }

    private static LogicalPlan joinWithNext(Function<AnalyzedRelation, LogicalPlan> plan, LogicalPlan source, AnalyzedRelation nextRel, Set<RelationName> joinNames, Map<Set<RelationName>, JoinPair> joinPairs, Map<Set<RelationName>, Symbol> queryParts, AnalyzedRelation leftRelation, boolean hashJoinEnabled) {
        Symbol condition;
        JoinType type;
        RelationName nextName = nextRel.relationName();
        JoinPair joinPair = JoinPlanBuilder.removeMatch(joinPairs, joinNames, nextName);
        if (joinPair == null) {
            type = JoinType.CROSS;
            condition = null;
        } else {
            type = JoinPlanBuilder.maybeInvertPair(nextName, joinPair);
            condition = joinPair.condition();
        }
        LogicalPlan nextPlan = plan.apply(nextRel);
        Symbol query = AndOperator.join(Stream.of(JoinPlanBuilder.removeMatch(queryParts, joinNames, nextName), queryParts.remove(Collections.singleton(nextName))).filter(Objects::nonNull).iterator());
        return Filter.create(JoinPlanBuilder.createJoinPlan(source, nextPlan, type, condition, leftRelation, nextRel, query, hashJoinEnabled), query);
    }

    private static Symbol removeParts(Map<Set<RelationName>, Symbol> queryParts, RelationName lhsName, RelationName rhsName) {
        Symbol left = queryParts.remove(Collections.singleton(lhsName));
        Symbol right = queryParts.remove(Collections.singleton(rhsName));
        Symbol both = queryParts.remove(Sets.newHashSet(lhsName, rhsName));
        return AndOperator.join(Stream.of(left, right, both).filter(Objects::nonNull).iterator());
    }

    @Nullable
    private static <V> V removeMatch(Map<Set<RelationName>, V> valuesByNames, Set<RelationName> names, RelationName nextName) {
        for (RelationName name : names) {
            V v = valuesByNames.remove(Sets.newHashSet(name, nextName));
            if (v == null) continue;
            return v;
        }
        return null;
    }
}

