/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import com.carrotsearch.hppc.ObjectIntHashMap;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class JoinOrdering {
    private JoinOrdering() {
    }

    static Collection<RelationName> getOrderedRelationNames(Collection<RelationName> sourceRelations, Set<? extends Set<RelationName>> explicitJoinConditions, Set<? extends Set<RelationName>> implicitJoinConditions) {
        if (sourceRelations.size() == 2) {
            return sourceRelations;
        }
        if (explicitJoinConditions.isEmpty() && implicitJoinConditions.isEmpty()) {
            return sourceRelations;
        }
        return JoinOrdering.orderByJoinConditions(sourceRelations, explicitJoinConditions, implicitJoinConditions);
    }

    static Collection<RelationName> orderByJoinConditions(Collection<RelationName> relations, Set<? extends Set<RelationName>> explicitJoinedRelations, Set<? extends Set<RelationName>> implicitJoinedRelations) {
        ArrayList<Set<RelationName>> pairsWithJoinConditions = new ArrayList<Set<RelationName>>(explicitJoinedRelations);
        pairsWithJoinConditions.addAll(implicitJoinedRelations);
        ObjectIntHashMap<RelationName> occurrences = JoinOrdering.getOccurrencesInJoinConditions(relations.size(), explicitJoinedRelations, implicitJoinedRelations);
        Set<RelationName> firstJoinPair = JoinOrdering.findAndRemoveFirstJoinPair(occurrences, pairsWithJoinConditions);
        assert (firstJoinPair != null) : "firstJoinPair should not be null";
        LinkedHashSet<RelationName> bestOrder = new LinkedHashSet<RelationName>(firstJoinPair);
        JoinOrdering.buildBestOrderByJoinConditions(pairsWithJoinConditions, bestOrder);
        bestOrder.addAll(relations);
        return bestOrder;
    }

    private static ObjectIntHashMap<RelationName> getOccurrencesInJoinConditions(int numberOfRelations, Set<? extends Set<RelationName>> explicitJoinedRelations, Set<? extends Set<RelationName>> implicitJoinedRelations) {
        ObjectIntHashMap occurrences = new ObjectIntHashMap(numberOfRelations);
        explicitJoinedRelations.forEach(o -> o.forEach(qName -> occurrences.putOrAdd(qName, 1, 1)));
        implicitJoinedRelations.forEach(o -> o.forEach(qName -> occurrences.putOrAdd(qName, 1, 1)));
        return occurrences;
    }

    @VisibleForTesting
    static Set<RelationName> findAndRemoveFirstJoinPair(ObjectIntHashMap<RelationName> occurrences, Collection<Set<RelationName>> joinPairs) {
        Iterator<Set<RelationName>> setsIterator = joinPairs.iterator();
        while (setsIterator.hasNext()) {
            Set<RelationName> set = setsIterator.next();
            for (RelationName name : set) {
                int count = occurrences.getOrDefault((Object)name, 0);
                if (count <= 1) continue;
                setsIterator.remove();
                return set;
            }
        }
        return joinPairs.iterator().next();
    }

    private static void buildBestOrderByJoinConditions(List<Set<RelationName>> sets, LinkedHashSet<RelationName> bestOrder) {
        Iterator<Set<RelationName>> setsIterator = sets.iterator();
        block0: while (setsIterator.hasNext()) {
            Set<RelationName> set = setsIterator.next();
            for (RelationName name : set) {
                if (!bestOrder.contains(name)) continue;
                bestOrder.addAll(set);
                setsIterator.remove();
                setsIterator = sets.iterator();
                continue block0;
            }
        }
        sets.forEach(bestOrder::addAll);
    }
}

