/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.action.FutureActionListener;
import io.crate.action.LimitedExponentialBackoff;
import io.crate.analyze.OrderBy;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.TypeGuessEstimateRowSize;
import io.crate.data.CollectionBucket;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.RowN;
import io.crate.data.SentinelRow;
import io.crate.exceptions.ColumnValidationException;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.upsert.GeneratedColumns;
import io.crate.execution.dml.upsert.InsertSourceFromCells;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.dml.upsert.TransportShardUpsertAction;
import io.crate.execution.dsl.projection.ColumnIndexWriterProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.GroupRowsByShard;
import io.crate.execution.engine.indexing.IndexNameResolver;
import io.crate.execution.engine.indexing.ShardLocation;
import io.crate.execution.engine.indexing.ShardedRequests;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.execution.support.RetryListener;
import io.crate.expression.InputFactory;
import io.crate.expression.InputRow;
import io.crate.expression.symbol.Assignments;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.IndexParts;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreatePartitionsRequest;
import org.elasticsearch.action.admin.indices.create.TransportCreatePartitionsAction;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.index.IndexNotFoundException;

public class InsertFromValues
implements LogicalPlan {
    private static final BackoffPolicy BACK_OFF_POLICY = LimitedExponentialBackoff.limitedExponential(1000);
    private final TableFunctionRelation tableFunctionRelation;
    private final ColumnIndexWriterProjection writerProjection;

    InsertFromValues(TableFunctionRelation tableFunctionRelation, ColumnIndexWriterProjection writerProjection) {
        this.tableFunctionRelation = tableFunctionRelation;
        this.writerProjection = writerProjection;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.INSERT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        void var14_23;
        Symbol[] assignmentSources;
        DocTableInfo tableInfo = (DocTableInfo)dependencies.schemas().getTableInfo(this.writerProjection.tableIdent(), Operation.INSERT);
        InputFactory inputFactory = new InputFactory(dependencies.nodeContext());
        InputFactory.Context<CollectExpression<Row, ?>> context = inputFactory.ctxForInputColumns(plannerContext.transactionContext());
        List<Symbol> allColumnSymbols = InputColumns.create(this.writerProjection.allTargetColumns(), new InputColumns.SourceSymbols(this.writerProjection.allTargetColumns()));
        ArrayList insertInputs = new ArrayList(allColumnSymbols.size());
        for (Symbol symbol : allColumnSymbols) {
            insertInputs.add(context.add(symbol));
        }
        ArrayList partitionedByInputs = new ArrayList(this.writerProjection.partitionedBySymbols().size());
        for (Symbol symbol : this.writerProjection.partitionedBySymbols()) {
            partitionedByInputs.add(context.add(symbol));
        }
        ArrayList arrayList = new ArrayList(this.writerProjection.ids().size());
        for (Symbol symbol : this.writerProjection.ids()) {
            arrayList.add(context.add(symbol));
        }
        if (this.writerProjection.clusteredBy() != null) {
            Input<?> input = context.add(this.writerProjection.clusteredBy());
        } else {
            Object var13_18 = null;
        }
        if (this.writerProjection.onDuplicateKeyAssignments() == null) {
            Object var14_21 = null;
            assignmentSources = null;
        } else {
            Assignments assignments = Assignments.convert(this.writerProjection.onDuplicateKeyAssignments(), dependencies.nodeContext());
            assignmentSources = assignments.bindSources(tableInfo, params, subQueryResults);
            String[] stringArray = assignments.targetNames();
        }
        Supplier<String> indexNameResolver = IndexNameResolver.create(this.writerProjection.tableIdent(), this.writerProjection.partitionIdent(), partitionedByInputs);
        GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item> grouper = this.createRowsByShardGrouper(assignmentSources, insertInputs, indexNameResolver, context, plannerContext, dependencies.clusterService());
        ArrayList rows = new ArrayList();
        InsertFromValues.evaluateValueTableFunction(this.tableFunctionRelation.functionImplementation(), this.tableFunctionRelation.function().arguments(), this.writerProjection.allTargetColumns(), tableInfo, params, plannerContext, subQueryResults).forEachRemaining(rows::add);
        List<Symbol> returnValues = this.writerProjection.returnValues();
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(plannerContext.transactionContext().sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.setting().get(dependencies.settings()), this.writerProjection.isIgnoreDuplicateKeys() ? ShardUpsertRequest.DuplicateKeyAction.IGNORE : ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, rows.size() > 1, (String[])var14_23, this.writerProjection.allTargetColumns().toArray(new Reference[0]), returnValues.isEmpty() ? null : returnValues.toArray(new Symbol[0]), plannerContext.jobId(), false);
        ShardedRequests shardedRequests = new ShardedRequests(builder::newRequest, RamAccounting.NO_ACCOUNTING);
        HashMap<String, InsertSourceFromCells> validatorsCache = new HashMap<String, InsertSourceFromCells>();
        for (Row row : rows) {
            grouper.accept(shardedRequests, row);
            try {
                void var13_19;
                InsertFromValues.checkPrimaryKeyValuesNotNull(arrayList);
                InsertFromValues.checkClusterByValueNotNull(var13_19);
                this.checkConstraintsOnGeneratedSource(row.materialize(), indexNameResolver.get(), tableInfo, plannerContext, validatorsCache);
            }
            catch (Throwable t2) {
                consumer.accept(null, t2);
            }
        }
        validatorsCache.clear();
        TransportActionProvider actionProvider = dependencies.transportActionProvider();
        ((CompletableFuture)InsertFromValues.createIndices(actionProvider.transportBulkCreateIndicesAction(), shardedRequests.itemsByMissingIndex().keySet(), dependencies.clusterService(), plannerContext.jobId()).thenCompose(acknowledgedResponse -> {
            Collection<ShardUpsertRequest> shardUpsertRequests = InsertFromValues.resolveAndGroupShardRequests(shardedRequests, dependencies.clusterService()).values();
            return this.execute(shardUpsertRequests, actionProvider.transportShardUpsertAction(), dependencies.scheduler());
        })).whenComplete((response, t) -> {
            if (t == null) {
                if (returnValues.isEmpty()) {
                    consumer.accept(InMemoryBatchIterator.of(new Row1(response.numSuccessfulWrites()), SentinelRow.SENTINEL), null);
                } else {
                    consumer.accept(InMemoryBatchIterator.of(new CollectionBucket(response.resultRows()), SentinelRow.SENTINEL, false), null);
                }
            } else {
                consumer.accept(null, (Throwable)t);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<CompletableFuture<Long>> executeBulk(DependencyCarrier dependencies, PlannerContext plannerContext, List<Row> bulkParams, SubQueryResults subQueryResults) {
        String[] updateColumnNames;
        Assignments assignments;
        DocTableInfo tableInfo = (DocTableInfo)dependencies.schemas().getTableInfo(this.writerProjection.tableIdent(), Operation.INSERT);
        if (this.writerProjection.onDuplicateKeyAssignments() == null) {
            assignments = null;
            updateColumnNames = null;
        } else {
            assignments = Assignments.convert(this.writerProjection.onDuplicateKeyAssignments(), dependencies.nodeContext());
            updateColumnNames = assignments.targetNames();
        }
        InputFactory inputFactory = new InputFactory(dependencies.nodeContext());
        InputFactory.Context<CollectExpression<Row, ?>> context = inputFactory.ctxForInputColumns(plannerContext.transactionContext());
        List<Symbol> allColumnSymbols = InputColumns.create(this.writerProjection.allTargetColumns(), new InputColumns.SourceSymbols(this.writerProjection.allTargetColumns()));
        ArrayList insertInputs = new ArrayList(allColumnSymbols.size());
        for (Symbol symbol : allColumnSymbols) {
            insertInputs.add(context.add(symbol));
        }
        ArrayList partitionedByInputs = new ArrayList(this.writerProjection.partitionedBySymbols().size());
        for (Symbol symbol : this.writerProjection.partitionedBySymbols()) {
            partitionedByInputs.add(context.add(symbol));
        }
        ArrayList arrayList = new ArrayList(this.writerProjection.ids().size());
        for (Symbol symbol : this.writerProjection.ids()) {
            arrayList.add(context.add(symbol));
        }
        if (this.writerProjection.clusteredBy() != null) {
            Input<?> input = context.add(this.writerProjection.clusteredBy());
        } else {
            Object var14_19 = null;
        }
        Supplier<String> supplier = IndexNameResolver.create(this.writerProjection.tableIdent(), this.writerProjection.partitionIdent(), partitionedByInputs);
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(plannerContext.transactionContext().sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.setting().get(dependencies.settings()), this.writerProjection.isIgnoreDuplicateKeys() ? ShardUpsertRequest.DuplicateKeyAction.IGNORE : ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, true, updateColumnNames, this.writerProjection.allTargetColumns().toArray(new Reference[0]), null, plannerContext.jobId(), true);
        ShardedRequests shardedRequests = new ShardedRequests(builder::newRequest, RamAccounting.NO_ACCOUNTING);
        HashMap<String, InsertSourceFromCells> validatorsCache = new HashMap<String, InsertSourceFromCells>();
        IntArrayList bulkIndices = new IntArrayList();
        List<CompletableFuture<Long>> results = InsertFromValues.createUnsetFutures(bulkParams.size());
        for (int bulkIdx = 0; bulkIdx < bulkParams.size(); ++bulkIdx) {
            Row param = bulkParams.get(bulkIdx);
            Symbol[] assignmentSources = assignments != null ? assignments.bindSources(tableInfo, param, subQueryResults) : null;
            GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item> grouper = this.createRowsByShardGrouper(assignmentSources, insertInputs, supplier, context, plannerContext, dependencies.clusterService());
            try {
                Iterator<Row> rows = InsertFromValues.evaluateValueTableFunction(this.tableFunctionRelation.functionImplementation(), this.tableFunctionRelation.function().arguments(), this.writerProjection.allTargetColumns(), tableInfo, param, plannerContext, subQueryResults);
                while (rows.hasNext()) {
                    void var14_20;
                    Row row = rows.next();
                    grouper.accept(shardedRequests, row);
                    InsertFromValues.checkPrimaryKeyValuesNotNull(arrayList);
                    InsertFromValues.checkClusterByValueNotNull(var14_20);
                    this.checkConstraintsOnGeneratedSource(row.materialize(), supplier.get(), tableInfo, plannerContext, validatorsCache);
                    bulkIndices.add(bulkIdx);
                }
                continue;
            }
            catch (Throwable t2) {
                for (CompletableFuture completableFuture : results) {
                    completableFuture.completeExceptionally(t2);
                }
                return results;
            }
        }
        validatorsCache.clear();
        TransportActionProvider actionProvider = dependencies.transportActionProvider();
        ((CompletableFuture)InsertFromValues.createIndices(actionProvider.transportBulkCreateIndicesAction(), shardedRequests.itemsByMissingIndex().keySet(), dependencies.clusterService(), plannerContext.jobId()).thenCompose(acknowledgedResponse -> {
            Collection<ShardUpsertRequest> shardUpsertRequests = InsertFromValues.resolveAndGroupShardRequests(shardedRequests, dependencies.clusterService()).values();
            return this.execute(shardUpsertRequests, actionProvider.transportShardUpsertAction(), dependencies.scheduler());
        })).whenComplete((response, t) -> {
            if (t == null) {
                long[] resultRowCount = InsertFromValues.createBulkResponse(response, bulkParams.size(), bulkIndices);
                for (int i = 0; i < bulkParams.size(); ++i) {
                    ((CompletableFuture)results.get(i)).complete(resultRowCount[i]);
                }
            } else {
                for (CompletableFuture result : results) {
                    result.completeExceptionally((Throwable)t);
                }
            }
        });
        return results;
    }

    private GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item> createRowsByShardGrouper(Symbol[] assignmentSources, ArrayList<Input<?>> insertInputs, Supplier<String> indexNameResolver, InputFactory.Context<CollectExpression<Row, ?>> collectContext, PlannerContext plannerContext, ClusterService clusterService) {
        InputRow insertValues = new InputRow(insertInputs);
        Function<String, ShardUpsertRequest.Item> itemFactory = id -> new ShardUpsertRequest.Item((String)id, assignmentSources, insertValues.materialize(), null, null, null);
        RowShardResolver rowShardResolver = new RowShardResolver(plannerContext.transactionContext(), plannerContext.nodeContext(), this.writerProjection.primaryKeys(), this.writerProjection.ids(), this.writerProjection.clusteredByIdent(), this.writerProjection.clusteredBy());
        return new GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item>(clusterService, rowShardResolver, new TypeGuessEstimateRowSize(), indexNameResolver, collectContext.expressions(), itemFactory, true);
    }

    private static void checkPrimaryKeyValuesNotNull(ArrayList<Input<?>> primaryKeyInputs) {
        for (Input<?> primaryKey : primaryKeyInputs) {
            if (primaryKey.value() != null) continue;
            throw new IllegalArgumentException("Primary key value must not be NULL");
        }
    }

    private static void checkClusterByValueNotNull(@Nullable Input<?> clusterByInput) {
        if (clusterByInput != null && clusterByInput.value() == null) {
            throw new IllegalArgumentException("Clustered by value must not be NULL");
        }
    }

    private void checkConstraintsOnGeneratedSource(Object[] cells, String indexName, DocTableInfo tableInfo, PlannerContext plannerContext, HashMap<String, InsertSourceFromCells> validatorsCache) throws Throwable {
        InsertSourceFromCells validator = validatorsCache.computeIfAbsent(indexName, index -> new InsertSourceFromCells(plannerContext.transactionContext(), plannerContext.nodeContext(), tableInfo, (String)index, GeneratedColumns.Validation.VALUE_MATCH, this.writerProjection.allTargetColumns()));
        validator.generateSourceAndCheckConstraints(cells);
    }

    private static Iterator<Row> evaluateValueTableFunction(TableFunctionImplementation<?> funcImplementation, List<Symbol> arguments, List<Reference> allTargetReferences, DocTableInfo tableInfo, Row params, PlannerContext plannerContext, SubQueryResults subQueryResults) {
        SymbolEvaluator symbolEval = new SymbolEvaluator(plannerContext.transactionContext(), plannerContext.nodeContext(), subQueryResults);
        Function<Symbol, Input> eval = symbol -> (Input)symbol.accept(symbolEval, params);
        ArrayList<Input> boundArguments = new ArrayList<Input>(arguments.size());
        for (int i = 0; i < arguments.size(); ++i) {
            boundArguments.add(eval.apply(arguments.get(i)));
        }
        Iterable rows = (Iterable)funcImplementation.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), boundArguments.toArray(new Input[0]));
        return StreamSupport.stream(rows.spliterator(), false).map(row -> InsertFromValues.cast(row, allTargetReferences, tableInfo)).iterator();
    }

    private static Row cast(Row row, List<Reference> columnReferences, DocTableInfo tableInfo) {
        if (row == null) {
            return null;
        }
        Object[] cells = new Object[row.numColumns()];
        for (int i = 0; i < cells.length; ++i) {
            Reference reference = columnReferences.get(i);
            DataType<?> targetType = reference.valueType();
            Object value = row.get(i);
            try {
                cells[i] = targetType.implicitCast(value);
                continue;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ColumnValidationException(reference.column().name(), tableInfo.ident(), "Invalid value '" + value + "' for type '" + targetType + "'");
            }
        }
        return new RowN(cells);
    }

    private static ShardLocation getShardLocation(String indexName, String id, @Nullable String routing, ClusterService clusterService) {
        ShardIterator shardIterator = clusterService.operationRouting().indexShards(clusterService.state(), indexName, id, routing);
        ShardRouting shardRouting = shardIterator.nextOrNull();
        String nodeId = shardRouting == null ? null : (!shardRouting.active() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId());
        return new ShardLocation(shardIterator.shardId(), nodeId);
    }

    private static <TReq extends ShardRequest<TReq, TItem>, TItem extends ShardRequest.Item> Map<ShardLocation, TReq> resolveAndGroupShardRequests(ShardedRequests<TReq, TItem> shardedRequests, ClusterService clusterService) {
        Iterator<Map.Entry<String, List<ShardedRequests.ItemAndRoutingAndSourceInfo<TItem>>>> itemsByMissingIndex = shardedRequests.itemsByMissingIndex().entrySet().iterator();
        while (itemsByMissingIndex.hasNext()) {
            Map.Entry<String, List<ShardedRequests.ItemAndRoutingAndSourceInfo<TItem>>> entry = itemsByMissingIndex.next();
            String index = entry.getKey();
            List<ShardedRequests.ItemAndRoutingAndSourceInfo<TItem>> requestItems = entry.getValue();
            Iterator<ShardedRequests.ItemAndRoutingAndSourceInfo<TItem>> requestItemsIterator = requestItems.iterator();
            while (requestItemsIterator.hasNext()) {
                ShardLocation shardLocation;
                ShardedRequests.ItemAndRoutingAndSourceInfo<TItem> itemAndRoutingAndSourceInfo = requestItemsIterator.next();
                try {
                    shardLocation = InsertFromValues.getShardLocation(index, ((ShardRequest.Item)itemAndRoutingAndSourceInfo.item()).id(), itemAndRoutingAndSourceInfo.routing(), clusterService);
                }
                catch (IndexNotFoundException e) {
                    if (IndexParts.isPartitioned(index)) {
                        requestItemsIterator.remove();
                        continue;
                    }
                    throw e;
                }
                shardedRequests.add((ShardRequest.Item)itemAndRoutingAndSourceInfo.item(), 0L, shardLocation, null);
                requestItemsIterator.remove();
            }
            if (!requestItems.isEmpty()) continue;
            itemsByMissingIndex.remove();
        }
        return shardedRequests.itemsByShard();
    }

    private CompletableFuture<ShardResponse.CompressedResult> execute(Collection<ShardUpsertRequest> shardUpsertRequests, TransportShardUpsertAction shardUpsertAction, ScheduledExecutorService scheduler) {
        final ShardResponse.CompressedResult compressedResult = new ShardResponse.CompressedResult();
        if (shardUpsertRequests.isEmpty()) {
            return CompletableFuture.completedFuture(compressedResult);
        }
        final CompletableFuture<ShardResponse.CompressedResult> result = new CompletableFuture<ShardResponse.CompressedResult>();
        final AtomicInteger numRequests = new AtomicInteger(shardUpsertRequests.size());
        final AtomicReference<Object> lastFailure = new AtomicReference<Object>(null);
        for (final ShardUpsertRequest request : shardUpsertRequests) {
            ActionListener<ShardResponse> listener = new ActionListener<ShardResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(ShardResponse shardResponse) {
                    Exception throwable = shardResponse.failure();
                    if (throwable == null) {
                        ShardResponse.CompressedResult compressedResult2 = compressedResult;
                        synchronized (compressedResult2) {
                            compressedResult.update(shardResponse);
                        }
                    } else {
                        lastFailure.set(throwable);
                    }
                    this.countdown();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Exception e) {
                    if (!InsertFromValues.partitionWasDeleted(e, request.index())) {
                        ShardResponse.CompressedResult compressedResult2 = compressedResult;
                        synchronized (compressedResult2) {
                            compressedResult.markAsFailed(request.items());
                        }
                    }
                    lastFailure.set(e);
                    this.countdown();
                }

                private void countdown() {
                    if (numRequests.decrementAndGet() == 0) {
                        Throwable throwable = (Throwable)lastFailure.get();
                        if (throwable == null) {
                            result.complete(compressedResult);
                        } else if (!SQLExceptions.isDocumentAlreadyExistsException(throwable = SQLExceptions.unwrap(throwable, t -> t instanceof RuntimeException)) && (InsertFromValues.partitionWasDeleted(throwable, request.index()) || InsertFromValues.partitionClosed(throwable, request.index()) || InsertFromValues.mixedArgumentTypesFailure(throwable))) {
                            result.complete(compressedResult);
                        } else {
                            result.completeExceptionally(throwable);
                        }
                    }
                }
            };
            shardUpsertAction.execute(request, new RetryListener<ShardResponse>(scheduler, l -> shardUpsertAction.execute(request, l), listener, BACK_OFF_POLICY));
        }
        return result;
    }

    private static boolean mixedArgumentTypesFailure(Throwable throwable) {
        return throwable instanceof ClassCastException || throwable instanceof NotSerializableExceptionWrapper;
    }

    private static boolean partitionWasDeleted(Throwable throwable, String index) {
        return throwable instanceof IndexNotFoundException && IndexParts.isPartitioned(index);
    }

    private static boolean partitionClosed(Throwable throwable, String index) {
        if (throwable instanceof ClusterBlockException && IndexParts.isPartitioned(index)) {
            for (ClusterBlock clusterBlock : ((ClusterBlockException)throwable).blocks()) {
                if (!clusterBlock.equals(IndexMetadata.INDEX_CLOSED_BLOCK)) continue;
                return true;
            }
        }
        return false;
    }

    private static CompletableFuture<AcknowledgedResponse> createIndices(TransportCreatePartitionsAction createPartitionsAction, Set<String> indices, ClusterService clusterService, UUID jobId) {
        Metadata metadata = clusterService.state().getMetadata();
        ArrayList<String> indicesToCreate = new ArrayList<String>();
        for (String index : indices) {
            if (!IndexParts.isPartitioned(index) || metadata.hasIndex(index)) continue;
            indicesToCreate.add(index);
        }
        if (indicesToCreate.isEmpty()) {
            return CompletableFuture.completedFuture(new AcknowledgedResponse(true));
        }
        FutureActionListener<AcknowledgedResponse, AcknowledgedResponse> listener = new FutureActionListener<AcknowledgedResponse, AcknowledgedResponse>(r -> r);
        createPartitionsAction.execute(new CreatePartitionsRequest(indicesToCreate, jobId), listener);
        return listener;
    }

    private static long[] createBulkResponse(ShardResponse.CompressedResult result, int bulkResponseSize, IntArrayList bulkIndices) {
        long[] resultRowCount = new long[bulkResponseSize];
        Arrays.fill(resultRowCount, 0L);
        for (int i = 0; i < bulkIndices.size(); ++i) {
            int resultIdx = bulkIndices.get(i);
            if (result.successfulWrites(i)) {
                int n = resultIdx;
                resultRowCount[n] = resultRowCount[n] + 1L;
                continue;
            }
            if (!result.failed(i)) continue;
            resultRowCount[resultIdx] = -2L;
        }
        return resultRowCount;
    }

    private static <T> List<CompletableFuture<T>> createUnsetFutures(int num) {
        ArrayList<CompletableFuture<T>> results = new ArrayList<CompletableFuture<T>>(num);
        for (int i = 0; i < num; ++i) {
            results.add(new CompletableFuture());
        }
        return results;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        return null;
    }

    @Override
    public List<Symbol> outputs() {
        return List.of();
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return List.of();
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        return this;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    @Override
    public long numExpectedRows() {
        return -1L;
    }

    @Override
    public long estimatedRowSize() {
        return 0L;
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitInsert(this, context);
    }
}

