/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.ColumnIndexWriterProjection;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Insert
implements LogicalPlan {
    private final ColumnIndexWriterProjection writeToTable;
    @Nullable
    private final EvalProjection applyCasts;
    final LogicalPlan source;

    public Insert(LogicalPlan source, ColumnIndexWriterProjection writeToTable, @Nullable EvalProjection applyCasts) {
        this.source = source;
        this.writeToTable = writeToTable;
        this.applyCasts = applyCasts;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan sourcePlan = this.source.build(plannerContext, projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults);
        if (this.applyCasts != null) {
            sourcePlan.addProjection(this.applyCasts);
        }
        ColumnIndexWriterProjection boundIndexWriterProjection = this.writeToTable.bind(x -> SubQueryAndParamBinder.convert(x, params, subQueryResults));
        if (sourcePlan.resultDescription().hasRemainingLimitOrOffset()) {
            ExecutionPlan localMerge = Merge.ensureOnHandler(sourcePlan, plannerContext);
            localMerge.addProjection(boundIndexWriterProjection);
            return localMerge;
        }
        sourcePlan.addProjection(boundIndexWriterProjection);
        ExecutionPlan localMerge = Merge.ensureOnHandler(sourcePlan, plannerContext);
        if (sourcePlan != localMerge) {
            localMerge.addProjection(MergeCountProjection.INSTANCE);
        }
        return localMerge;
    }

    ColumnIndexWriterProjection columnIndexWriterProjection() {
        return this.writeToTable;
    }

    @Override
    public List<Symbol> outputs() {
        return this.writeToTable.outputs();
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return Collections.emptyList();
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of(this.source);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Insert(Lists2.getOnlyElement(sources), this.writeToTable, this.applyCasts);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        LogicalPlan newSource = this.source.pruneOutputsExcept(tableStats, this.source.outputs());
        if (newSource == this.source) {
            return this;
        }
        return this.replaceSources(List.of(newSource));
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return this.source.dependencies();
    }

    @Override
    public long numExpectedRows() {
        return 1L;
    }

    @Override
    public long estimatedRowSize() {
        return this.source.estimatedRowSize();
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitInsert(this, context);
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.INSERT;
    }

    public Collection<Projection> projections() {
        if (this.applyCasts == null) {
            return List.of(this.writeToTable);
        }
        return List.of(this.applyCasts, this.writeToTable);
    }
}

