/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.expression.symbol.DefaultTraversalSymbolVisitor;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class HashJoinConditionSymbolsExtractor {
    private static final SymbolExtractor SYMBOL_EXTRACTOR = new SymbolExtractor();
    private static final RelationExtractor RELATION_EXTRACTOR = new RelationExtractor();

    public static Map<RelationName, List<Symbol>> extract(Symbol symbol) {
        Context ctx = new Context();
        symbol.accept(SYMBOL_EXTRACTOR, ctx);
        return ctx.symbolsPerRelation;
    }

    private HashJoinConditionSymbolsExtractor() {
    }

    private static class Context {
        boolean insideEqOperator = false;
        Map<RelationName, List<Symbol>> symbolsPerRelation = new LinkedHashMap<RelationName, List<Symbol>>();

        private Context() {
        }
    }

    private static class SymbolExtractor
    extends DefaultTraversalSymbolVisitor<Context, Void> {
        private SymbolExtractor() {
        }

        @Override
        public Void visitFunction(Function function, Context context) {
            String functionName;
            switch (functionName = function.name()) {
                case "op_and": {
                    return (Void)super.visitFunction(function, context);
                }
                case "op_=": {
                    context.insideEqOperator = true;
                    int duplicatePos = 0;
                    for (Symbol symbol : function.arguments()) {
                        RelationName relation = symbol.accept(RELATION_EXTRACTOR, null);
                        List symbols = context.symbolsPerRelation.computeIfAbsent(relation, k -> new ArrayList());
                        if (symbols.contains(symbol)) {
                            duplicatePos = symbols.size();
                            continue;
                        }
                        symbols.add(symbol);
                    }
                    if (duplicatePos > 0) {
                        for (Map.Entry entry : context.symbolsPerRelation.entrySet()) {
                            List symbols = (List)entry.getValue();
                            if (symbols.size() <= duplicatePos) continue;
                            symbols.remove(duplicatePos);
                        }
                    }
                    context.insideEqOperator = false;
                    return null;
                }
            }
            if (context.insideEqOperator) {
                return (Void)super.visitFunction(function, context);
            }
            return null;
        }
    }

    private static class RelationExtractor
    extends SymbolVisitor<Void, RelationName> {
        private RelationExtractor() {
        }

        @Override
        public RelationName visitFunction(Function symbol, Void context) {
            for (Symbol arg : symbol.arguments()) {
                RelationName relation = arg.accept(this, context);
                if (relation == null) continue;
                return relation;
            }
            return null;
        }

        @Override
        public RelationName visitField(ScopedSymbol field, Void context) {
            return field.relation();
        }

        @Override
        public RelationName visitReference(Reference ref, Void context) {
            return ref.ident().tableIdent();
        }
    }
}

