/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.AggregationProjection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.AggregateMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public class HashAggregate
extends ForwardingLogicalPlan {
    private static final String MERGE_PHASE_NAME = "mergeOnHandler";
    final List<Function> aggregates;

    HashAggregate(LogicalPlan source, List<Function> aggregates) {
        super(source);
        this.aggregates = aggregates;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan executionPlan = this.source.build(plannerContext, projectionBuilder, -1, 0, null, null, params, subQueryResults);
        AggregationOutputValidator.validateOutputs(this.aggregates);
        SubQueryAndParamBinder paramBinder = new SubQueryAndParamBinder(params, subQueryResults);
        List<Symbol> sourceOutputs = this.source.outputs();
        if (executionPlan.resultDescription().hasRemainingLimitOrOffset()) {
            executionPlan = Merge.ensureOnHandler(executionPlan, plannerContext);
        }
        if (ExecutionPhases.executesOnHandler(plannerContext.handlerNode(), executionPlan.resultDescription().nodeIds())) {
            if (this.source.preferShardProjections()) {
                executionPlan.addProjection(projectionBuilder.aggregationProjection(sourceOutputs, this.aggregates, paramBinder, AggregateMode.ITER_PARTIAL, RowGranularity.SHARD, plannerContext.transactionContext().sessionContext().searchPath()));
                executionPlan.addProjection(projectionBuilder.aggregationProjection(this.aggregates, this.aggregates, paramBinder, AggregateMode.PARTIAL_FINAL, RowGranularity.CLUSTER, plannerContext.transactionContext().sessionContext().searchPath()));
                return executionPlan;
            }
            AggregationProjection fullAggregation = projectionBuilder.aggregationProjection(sourceOutputs, this.aggregates, paramBinder, AggregateMode.ITER_FINAL, RowGranularity.CLUSTER, plannerContext.transactionContext().sessionContext().searchPath());
            executionPlan.addProjection(fullAggregation);
            return executionPlan;
        }
        AggregationProjection toPartial = projectionBuilder.aggregationProjection(sourceOutputs, this.aggregates, paramBinder, AggregateMode.ITER_PARTIAL, this.source.preferShardProjections() ? RowGranularity.SHARD : RowGranularity.NODE, plannerContext.transactionContext().sessionContext().searchPath());
        executionPlan.addProjection(toPartial);
        AggregationProjection toFinal = projectionBuilder.aggregationProjection(this.aggregates, this.aggregates, paramBinder, AggregateMode.PARTIAL_FINAL, RowGranularity.CLUSTER, plannerContext.transactionContext().sessionContext().searchPath());
        return new Merge(executionPlan, new MergePhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), MERGE_PHASE_NAME, executionPlan.resultDescription().nodeIds().size(), 1, Collections.singletonList(plannerContext.handlerNode()), executionPlan.resultDescription().streamOutputs(), Collections.singletonList(toFinal), DistributionInfo.DEFAULT_BROADCAST, null), -1, 0, this.aggregates.size(), 1, null);
    }

    public List<Function> aggregates() {
        return this.aggregates;
    }

    @Override
    public List<Symbol> outputs() {
        return new ArrayList<Symbol>(this.aggregates);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new HashAggregate(Lists2.getOnlyElement(sources), this.aggregates);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        ArrayList<Function> newAggregates = new ArrayList<Function>();
        for (Symbol symbol : outputsToKeep) {
            SymbolVisitors.intersection(symbol, this.aggregates, newAggregates::add);
        }
        LinkedHashSet<Symbol> toKeep = new LinkedHashSet<Symbol>();
        for (Function newAggregate : newAggregates) {
            SymbolVisitors.intersection(newAggregate, this.source.outputs(), toKeep::add);
        }
        LogicalPlan logicalPlan = this.source.pruneOutputsExcept(tableStats, toKeep);
        if (this.source == logicalPlan && newAggregates == this.aggregates) {
            return this;
        }
        return new HashAggregate(logicalPlan, newAggregates);
    }

    @Override
    public long numExpectedRows() {
        return 1L;
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitHashAggregate(this, context);
    }

    public static class AggregationOutputValidator
    extends SymbolVisitor<OutputValidatorContext, Void> {
        private static final AggregationOutputValidator INSTANCE = new AggregationOutputValidator();

        public static void validateOutputs(Collection<? extends Symbol> outputs) {
            OutputValidatorContext ctx = new OutputValidatorContext();
            for (Symbol symbol : outputs) {
                ctx.insideAggregation = false;
                symbol.accept(INSTANCE, ctx);
            }
        }

        @Override
        public Void visitFunction(Function symbol, OutputValidatorContext context) {
            context.insideAggregation = context.insideAggregation || symbol.type().equals((Object)FunctionType.AGGREGATE);
            for (Symbol argument : symbol.arguments()) {
                argument.accept(this, context);
            }
            context.insideAggregation = false;
            return null;
        }

        @Override
        public Void visitReference(Reference symbol, OutputValidatorContext context) {
            Reference.IndexType indexType;
            if (context.insideAggregation && (indexType = symbol.indexType()) == Reference.IndexType.ANALYZED) {
                throw new IllegalArgumentException(Symbols.format("Cannot select analyzed column '%s' within grouping or aggregations", symbol));
            }
            return null;
        }

        @Override
        protected Void visitSymbol(Symbol symbol, OutputValidatorContext context) {
            return null;
        }
    }

    private static class OutputValidatorContext {
        private boolean insideAggregation = false;

        private OutputValidatorContext() {
        }
    }
}

