/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.where.DocKeys;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.PKLookupPhase;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.FilterProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.RefVisitor;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PKAndVersion;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;

public class Get
implements LogicalPlan {
    final DocTableRelation tableRelation;
    final DocKeys docKeys;
    final Symbol query;
    final long estimatedSizePerRow;
    private final List<Symbol> outputs;

    public Get(DocTableRelation table, DocKeys docKeys, Symbol query, List<Symbol> outputs, long estimatedSizePerRow) {
        this.tableRelation = table;
        this.docKeys = docKeys;
        this.query = query;
        this.estimatedSizePerRow = estimatedSizePerRow;
        this.outputs = outputs;
    }

    @Override
    public boolean preferShardProjections() {
        return true;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limitHint, int offsetHint, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        HashMap<String, Map<ShardId, List<PKAndVersion>>> idsByShardByNode = new HashMap<String, Map<ShardId, List<PKAndVersion>>>();
        DocTableInfo docTableInfo = (DocTableInfo)this.tableRelation.tableInfo();
        for (DocKeys.DocKey docKey : this.docKeys) {
            ArrayList<PKAndVersion> pkAndVersions;
            ShardRouting shardRouting;
            String id = docKey.getId(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
            if (id == null) continue;
            List<String> partitionValues = docKey.getPartitionValues(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
            String indexName = Get.indexName(docTableInfo, partitionValues);
            String routing = docKey.getRouting(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
            try {
                shardRouting = plannerContext.resolveShard(indexName, id, routing);
            }
            catch (IndexNotFoundException e) {
                if (docTableInfo.isPartitioned()) continue;
                throw e;
            }
            String currentNodeId = shardRouting.currentNodeId();
            if (currentNodeId == null && (currentNodeId = shardRouting.relocatingNodeId()) == null) {
                throw new ShardNotFoundException(shardRouting.shardId());
            }
            HashMap idsByShard = (HashMap)idsByShardByNode.get(currentNodeId);
            if (idsByShard == null) {
                idsByShard = new HashMap();
                idsByShardByNode.put(currentNodeId, idsByShard);
            }
            if ((pkAndVersions = (ArrayList<PKAndVersion>)idsByShard.get(shardRouting.shardId())) == null) {
                pkAndVersions = new ArrayList<PKAndVersion>();
                idsByShard.put(shardRouting.shardId(), pkAndVersions);
            }
            long version = docKey.version(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults).orElse(-3L);
            long sequenceNumber = docKey.sequenceNo(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults).orElse(-2L);
            long primaryTerm = docKey.primaryTerm(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults).orElse(0L);
            pkAndVersions.add(new PKAndVersion(id, version, sequenceNumber, primaryTerm));
        }
        ArrayList<ColumnIdent> docKeyColumns = new ArrayList<ColumnIdent>(docTableInfo.primaryKey());
        docKeyColumns.addAll(docTableInfo.partitionedBy());
        docKeyColumns.add(docTableInfo.clusteredBy());
        docKeyColumns.add(DocSysColumns.VERSION);
        docKeyColumns.add(DocSysColumns.SEQ_NO);
        docKeyColumns.add(DocSysColumns.PRIMARY_TERM);
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        List<Symbol> boundOutputs = Lists2.map(this.outputs, binder);
        Symbol boundQuery = binder.apply(this.query);
        AtomicBoolean requiresAdditionalFilteringOnNonDocKeyColumns = new AtomicBoolean(false);
        LinkedHashSet<Symbol> toCollectSet = new LinkedHashSet<Symbol>(boundOutputs);
        Consumer<Reference> addRefIfMatch = ref -> {
            toCollectSet.add((Symbol)ref);
            if (!docKeyColumns.contains(ref.column())) {
                requiresAdditionalFilteringOnNonDocKeyColumns.set(true);
            }
        };
        RefVisitor.visitRefs(boundQuery, addRefIfMatch);
        List<Symbol> toCollect = boundOutputs;
        ArrayList<Projection> projections = new ArrayList<Projection>();
        if (requiresAdditionalFilteringOnNonDocKeyColumns.get()) {
            toCollect = List.copyOf(toCollectSet);
            FilterProjection filterProjection = ProjectionBuilder.filterProjection(toCollect, boundQuery);
            projections.add(filterProjection);
            EvalProjection evalProjection = new EvalProjection(InputColumn.mapToInputColumns(boundOutputs));
            projections.add(evalProjection);
        }
        Collect collect = new Collect(new PKLookupPhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), docTableInfo.partitionedBy(), toCollect, idsByShardByNode), -1, 0, toCollect.size(), this.docKeys.size(), null);
        for (Projection projection : projections) {
            collect.addProjection(projection);
        }
        return collect;
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return List.of(this.tableRelation);
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        assert (sources.isEmpty()) : "Get has no sources, cannot replace them";
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        boolean excludedAny = false;
        for (Symbol output : this.outputs) {
            if (outputsToKeep.contains(output)) {
                newOutputs.add(output);
                continue;
            }
            excludedAny = true;
        }
        if (excludedAny) {
            return new Get(this.tableRelation, this.docKeys, this.query, newOutputs, this.estimatedSizePerRow);
        }
        return this;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    @Override
    public long estimatedRowSize() {
        return this.estimatedSizePerRow;
    }

    @Override
    public long numExpectedRows() {
        return this.docKeys.size();
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitGet(this, context);
    }

    public static String indexName(DocTableInfo tableInfo, @Nullable List<String> partitionValues) {
        RelationName relation = tableInfo.ident();
        if (tableInfo.isPartitioned()) {
            assert (partitionValues != null) : "values must not be null";
            return IndexParts.toIndexName(relation, PartitionName.encodeIdent(partitionValues));
        }
        return relation.indexNameOrAlias();
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("Get[").text(((DocTableInfo)this.tableRelation.tableInfo()).ident().toString()).text(" | ").text(Lists2.joinOn(", ", this.outputs, Symbol::toString)).text(" | ").text(this.docKeys.toString()).text(" | ").text(this.query.toString()).text("]");
    }
}

