/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.LogicalPlan;
import io.crate.statistics.TableStats;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ForwardingLogicalPlan
implements LogicalPlan {
    private final List<LogicalPlan> sources;
    final LogicalPlan source;

    public ForwardingLogicalPlan(LogicalPlan source) {
        this.source = source;
        this.sources = List.of(source);
    }

    public LogicalPlan source() {
        return this.source;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        LogicalPlan newSource = this.source.pruneOutputsExcept(tableStats, outputsToKeep);
        if (newSource == this.source) {
            return this;
        }
        return this.replaceSources(List.of(newSource));
    }

    @Override
    public List<Symbol> outputs() {
        return this.source.outputs();
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return this.source.baseTables();
    }

    @Override
    public Set<RelationName> getRelationNames() {
        return this.source.getRelationNames();
    }

    @Override
    public List<LogicalPlan> sources() {
        return this.sources;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return this.source.dependencies();
    }

    @Override
    public long numExpectedRows() {
        return this.source.numExpectedRows();
    }

    @Override
    public long estimatedRowSize() {
        return this.source.estimatedRowSize();
    }
}

