/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.FilterProjection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.metadata.RowGranularity;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class Filter
extends ForwardingLogicalPlan {
    final Symbol query;

    public static LogicalPlan create(LogicalPlan source, @Nullable Symbol query) {
        if (query == null) {
            return source;
        }
        assert (query.valueType().equals(DataTypes.BOOLEAN)) : "query must have a boolean result type, got query `" + query + "` with result type: " + query.valueType();
        if (Filter.isMatchAll(query)) {
            return source;
        }
        return new Filter(source, query);
    }

    private static boolean isMatchAll(Symbol query) {
        return query instanceof Literal && ((Literal)query).value() == Boolean.TRUE;
    }

    public Filter(LogicalPlan source, Symbol query) {
        super(source);
        this.query = query;
    }

    public Symbol query() {
        return this.query;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan executionPlan = this.source.build(plannerContext, projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults);
        Symbol boundQuery = SubQueryAndParamBinder.convert(this.query, params, subQueryResults);
        FilterProjection filterProjection = ProjectionBuilder.filterProjection(this.source.outputs(), boundQuery);
        if (executionPlan.resultDescription().executesOnShard()) {
            filterProjection.requiredGranularity(RowGranularity.SHARD);
        }
        executionPlan.addProjection(filterProjection);
        return executionPlan;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        LinkedHashSet<Symbol> toKeep = new LinkedHashSet<Symbol>(outputsToKeep);
        SymbolVisitors.intersection(this.query, this.source.outputs(), toKeep::add);
        LogicalPlan newSource = this.source.pruneOutputsExcept(tableStats, toKeep);
        if (newSource == this.source) {
            return this;
        }
        return new Filter(newSource, this.query);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Filter(Lists2.getOnlyElement(sources), this.query);
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitFilter(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.source::print;
        printContext.text("Filter[").text(this.query.toString()).text("]").nest(consumerArray);
    }

    public String toString() {
        return "Filter{src=" + this.source + ", query=" + this.query + "}";
    }
}

