/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class Eval
extends ForwardingLogicalPlan {
    private final List<Symbol> outputs;

    public static LogicalPlan create(LogicalPlan source, List<Symbol> outputs) {
        if (source.outputs().equals(outputs)) {
            return source;
        }
        return new Eval(source, outputs);
    }

    Eval(LogicalPlan source, List<Symbol> outputs) {
        super(source);
        this.outputs = outputs;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan executionPlan = this.source.build(plannerContext, projectionBuilder, limit, offset, null, pageSizeHint, params, subQueryResults);
        if (this.outputs.equals(this.source.outputs())) {
            return executionPlan;
        }
        return this.addEvalProjection(plannerContext, executionPlan, params, subQueryResults);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Eval(Lists2.getOnlyElement(sources), this.outputs);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        LogicalPlan newSource = this.source.pruneOutputsExcept(tableStats, outputsToKeep);
        if (this.source == newSource) {
            return this;
        }
        return new Eval(newSource, List.copyOf(outputsToKeep));
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(TableStats tableStats, Collection<Symbol> usedColumns) {
        FetchRewrite fetchRewrite = this.source.rewriteToFetch(tableStats, usedColumns);
        if (fetchRewrite == null) {
            return null;
        }
        LogicalPlan newSource = fetchRewrite.newPlan();
        Function<Symbol, Symbol> mapToFetchStubs = fetchRewrite.mapToFetchStubs();
        LinkedHashMap<Symbol, Symbol> newReplacedOutputs = new LinkedHashMap<Symbol, Symbol>();
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        for (Symbol sourceOutput : newSource.outputs()) {
            if (!(sourceOutput instanceof FetchMarker)) continue;
            newOutputs.add(sourceOutput);
        }
        for (Symbol output : this.outputs) {
            newReplacedOutputs.put(output, mapToFetchStubs.apply(output));
            SymbolVisitors.intersection(output, newSource.outputs(), newOutputs::add);
        }
        return new FetchRewrite(newReplacedOutputs, Eval.create(newSource, newOutputs));
    }

    private ExecutionPlan addEvalProjection(PlannerContext plannerContext, ExecutionPlan executionPlan, Row params, SubQueryResults subQueryResults) {
        PositionalOrderBy orderBy = executionPlan.resultDescription().orderBy();
        PositionalOrderBy newOrderBy = null;
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        List<Symbol> boundOutputs = Lists2.map(this.outputs, binder);
        if (orderBy != null && (newOrderBy = orderBy.tryMapToNewOutputs(this.source.outputs(), boundOutputs)) == null) {
            executionPlan = Merge.ensureOnHandler(executionPlan, plannerContext);
        }
        InputColumns.SourceSymbols ctx = new InputColumns.SourceSymbols(Lists2.map(this.source.outputs(), binder));
        executionPlan.addProjection(new EvalProjection(InputColumns.create(boundOutputs, ctx)), executionPlan.resultDescription().limit(), executionPlan.resultDescription().offset(), newOrderBy);
        return executionPlan;
    }

    public String toString() {
        return "Eval{src=" + this.source + ", out=" + this.outputs + "}";
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitEval(this, context);
    }
}

