/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.planner.node.dql.join.JoinType;
import java.util.HashSet;
import java.util.Set;

public class EquiJoinDetector {
    private static final Visitor VISITOR = new Visitor();

    public static boolean isHashJoinPossible(JoinType joinType, Symbol joinCondition) {
        if (joinType != JoinType.INNER) {
            return false;
        }
        return EquiJoinDetector.isEquiJoin(joinCondition);
    }

    private static boolean isEquiJoin(Symbol joinCondition) {
        assert (joinCondition != null) : "join condition must not be null on inner joins";
        Context context = new Context();
        joinCondition.accept(VISITOR, context);
        return context.isHashJoinPossible;
    }

    private static class Context {
        boolean isHashJoinPossible = false;
        boolean insideEqOperator = false;
        Set<RelationName> usedRelationsInsideEqOperatorArgument = new HashSet<RelationName>();

        private Context() {
        }
    }

    private static class Visitor
    extends SymbolVisitor<Context, Void> {
        private Visitor() {
        }

        @Override
        public Void visitFunction(Function function, Context context) {
            String functionName;
            switch (functionName = function.name()) {
                case "op_and": {
                    for (Symbol arg : function.arguments()) {
                        arg.accept(this, context);
                    }
                    break;
                }
                case "op_=": {
                    context.isHashJoinPossible = true;
                    context.insideEqOperator = true;
                    for (Symbol arg : function.arguments()) {
                        arg.accept(this, context);
                        if (context.usedRelationsInsideEqOperatorArgument.size() != 1) {
                            context.isHashJoinPossible = false;
                        }
                        context.usedRelationsInsideEqOperatorArgument = new HashSet<RelationName>();
                    }
                    break;
                }
                default: {
                    if (context.insideEqOperator) {
                        for (Symbol arg : function.arguments()) {
                            arg.accept(this, context);
                        }
                        break;
                    }
                    context.isHashJoinPossible = false;
                    return null;
                }
            }
            return null;
        }

        @Override
        public Void visitField(ScopedSymbol field, Context context) {
            if (context.insideEqOperator) {
                context.usedRelationsInsideEqOperatorArgument.add(field.relation());
            }
            return null;
        }

        @Override
        public Void visitReference(Reference ref, Context context) {
            if (context.insideEqOperator) {
                context.usedRelationsInsideEqOperatorArgument.add(ref.ident().tableIdent());
            }
            return null;
        }
    }
}

