/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.where.WhereClauseAnalyzer;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.dql.CountPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.TableStats;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Count
implements LogicalPlan {
    private static final String COUNT_PHASE_NAME = "count-merge";
    final AbstractTableRelation<?> tableRelation;
    final WhereClause where;
    private final List<Symbol> outputs;

    public Count(Function countFunction, AbstractTableRelation<?> tableRelation, WhereClause where) {
        this.outputs = List.of(countFunction);
        this.tableRelation = tableRelation;
        this.where = where;
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(plannerContext.nodeContext(), RowGranularity.CLUSTER, null, this.tableRelation);
        java.util.function.Function binder = new SubQueryAndParamBinder(params, subQueryResults).andThen(x -> normalizer.normalize((Symbol)x, plannerContext.transactionContext()));
        WhereClause boundWhere = WhereClauseAnalyzer.resolvePartitions(this.where.map(binder), this.tableRelation, plannerContext.transactionContext(), plannerContext.nodeContext());
        Routing routing = plannerContext.allocateRouting((TableInfo)this.tableRelation.tableInfo(), boundWhere, RoutingProvider.ShardSelection.ANY, plannerContext.transactionContext().sessionContext());
        CountPhase countPhase = new CountPhase(plannerContext.nextExecutionPhaseId(), routing, boundWhere.queryOrFallback(), DistributionInfo.DEFAULT_BROADCAST);
        MergePhase mergePhase = new MergePhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), COUNT_PHASE_NAME, countPhase.nodeIds().size(), 1, Collections.singletonList(plannerContext.handlerNode()), Collections.singletonList(DataTypes.LONG), Collections.singletonList(MergeCountProjection.INSTANCE), DistributionInfo.DEFAULT_BROADCAST, null);
        return new CountPlan(countPhase, mergePhase);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return List.of(this.tableRelation);
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        assert (sources.isEmpty()) : "Count has no sources, cannot replace them";
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        return this;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    @Override
    public long numExpectedRows() {
        return 1L;
    }

    @Override
    public long estimatedRowSize() {
        return 8L;
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitCount(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("Count[").text(this.tableRelation.tableInfo().ident().toString()).text(" | ").text(this.where.queryOrFallback().toString()).text("]");
    }
}

