/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.GeneratedColumnExpander;
import io.crate.analyze.OrderBy;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.where.WhereClauseAnalyzer;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.exceptions.VersioninigValidationException;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.FetchStub;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.DocReferences;
import io.crate.metadata.Reference;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.consumer.OrderByPositionVisitor;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.operators.EnsureNoMatchPredicate;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.symbol.Optimizer;
import io.crate.planner.selectivity.SelectivityFunctions;
import io.crate.statistics.Stats;
import io.crate.statistics.TableStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Collect
implements LogicalPlan {
    private static final String COLLECT_PHASE_NAME = "collect";
    final AbstractTableRelation<?> relation;
    private final boolean preferSourceLookup;
    private final List<Symbol> outputs;
    private final List<AbstractTableRelation<?>> baseTables;
    final TableInfo tableInfo;
    private final long numExpectedRows;
    private final long estimatedRowSize;
    WhereClause where;

    public static Collect create(AbstractTableRelation<?> relation, List<Symbol> toCollect, WhereClause where, Set<PlanHint> hints, TableStats tableStats, Row params) {
        Stats stats = tableStats.getStats(relation.tableInfo().ident());
        return new Collect(hints.contains((Object)PlanHint.PREFER_SOURCE_LOOKUP), relation, toCollect, where, SelectivityFunctions.estimateNumRows(stats, where.queryOrFallback(), params), stats.estimateSizeForColumns(toCollect));
    }

    public Collect(boolean preferSourceLookup, AbstractTableRelation<?> relation, List<Symbol> outputs, WhereClause where, long numExpectedRows, long estimatedRowSize) {
        this.preferSourceLookup = preferSourceLookup;
        this.outputs = outputs;
        this.baseTables = List.of(relation);
        this.numExpectedRows = numExpectedRows;
        this.estimatedRowSize = estimatedRowSize;
        if (where.hasQuery() && !(relation instanceof DocTableRelation)) {
            EnsureNoMatchPredicate.ensureNoMatchPredicate(where.queryOrFallback(), "Cannot use MATCH on system tables");
        }
        this.relation = relation;
        this.where = where;
        this.tableInfo = relation.tableInfo();
    }

    @Override
    public ExecutionPlan build(PlannerContext plannerContext, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(plannerContext.nodeContext(), RowGranularity.CLUSTER, null, this.relation);
        Function<Symbol, Symbol> binder = new SubQueryAndParamBinder(params, subQueryResults).andThen(x -> normalizer.normalize((Symbol)x, plannerContext.transactionContext()));
        RoutedCollectPhase collectPhase = this.createPhase(plannerContext, binder);
        PositionalOrderBy positionalOrderBy = Collect.getPositionalOrderBy(order, this.outputs);
        if (positionalOrderBy != null) {
            if (this.preferSourceLookup) {
                order = order.map(DocReferences::toSourceLookup);
            }
            collectPhase.orderBy(order.map(binder).exclude(s -> s instanceof Literal));
        }
        int limitAndOffset = Limit.limitAndOffset(limit, offset);
        Collect.maybeApplyPageSize(limitAndOffset, pageSizeHint, collectPhase);
        return new io.crate.planner.node.dql.Collect(collectPhase, -1, 0, this.outputs.size(), limitAndOffset, positionalOrderBy);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public WhereClause where() {
        return this.where;
    }

    public AbstractTableRelation<?> relation() {
        return this.relation;
    }

    private static boolean noLuceneSortSupport(OrderBy order) {
        for (Symbol sortKey : order.orderBySymbols()) {
            if (!SymbolVisitors.any(Collect::isPartitionColOrAnalyzed, sortKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPartitionColOrAnalyzed(Symbol s) {
        return s instanceof Reference && (((Reference)s).granularity() == RowGranularity.PARTITION || ((Reference)s).indexType() == Reference.IndexType.ANALYZED);
    }

    @Nullable
    private static PositionalOrderBy getPositionalOrderBy(@Nullable OrderBy order, List<Symbol> outputs) {
        if (order == null) {
            return null;
        }
        int[] positions = OrderByPositionVisitor.orderByPositionsOrNull(order.orderBySymbols(), outputs);
        if (positions == null) {
            return null;
        }
        if (Collect.noLuceneSortSupport(order)) {
            return null;
        }
        return new PositionalOrderBy(positions, order.reverseFlags(), order.nullsFirst());
    }

    private static void maybeApplyPageSize(int limit, @Nullable Integer pageSizeHint, RoutedCollectPhase collectPhase) {
        if (pageSizeHint == null) {
            if (limit > -1) {
                collectPhase.nodePageSizeHint(limit);
            }
        } else {
            collectPhase.pageSizeHint(pageSizeHint);
        }
    }

    private RoutedCollectPhase createPhase(PlannerContext plannerContext, Function<Symbol, Symbol> binder) {
        WhereClause boundWhere = this.where.map(binder);
        if (this.tableInfo instanceof DocTableInfo) {
            DocTableInfo docTable = (DocTableInfo)this.tableInfo;
            Symbol query = GeneratedColumnExpander.maybeExpand(boundWhere.queryOrFallback(), docTable.generatedColumns(), Lists2.concat(docTable.partitionedByColumns(), Lists2.map(docTable.primaryKey(), docTable::getReference)), plannerContext.nodeContext());
            if (!query.equals(boundWhere.queryOrFallback())) {
                boundWhere = new WhereClause(query, boundWhere.partitions(), boundWhere.clusteredBy());
            }
        }
        this.where = WhereClauseAnalyzer.resolvePartitions(boundWhere, this.relation, plannerContext.transactionContext(), plannerContext.nodeContext());
        if (this.where.hasVersions()) {
            throw VersioninigValidationException.versionInvalidUsage();
        }
        if (this.where.hasSeqNoAndPrimaryTerm()) {
            throw VersioninigValidationException.seqNoAndPrimaryTermUsage();
        }
        SessionContext sessionContext = plannerContext.transactionContext().sessionContext();
        List<Symbol> boundOutputs = Lists2.map(this.outputs, binder);
        return new RoutedCollectPhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), COLLECT_PHASE_NAME, plannerContext.allocateRouting(this.tableInfo, this.where, RoutingProvider.ShardSelection.ANY, sessionContext), this.tableInfo.rowGranularity(), this.preferSourceLookup && this.tableInfo instanceof DocTableInfo ? Lists2.map(boundOutputs, DocReferences::toSourceLookup) : boundOutputs, Collections.emptyList(), Optimizer.optimizeCasts(this.where.queryOrFallback(), plannerContext), DistributionInfo.DEFAULT_BROADCAST);
    }

    @Override
    public boolean preferShardProjections() {
        return this.tableInfo instanceof DocTableInfo;
    }

    @Override
    public List<AbstractTableRelation<?>> baseTables() {
        return this.baseTables;
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        assert (sources.isEmpty()) : "Collect has no sources, cannot replace them";
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(TableStats tableStats, Collection<Symbol> outputsToKeep) {
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        for (Symbol output : this.outputs) {
            if (!outputsToKeep.contains(output)) continue;
            newOutputs.add(output);
        }
        if (newOutputs.equals(this.outputs)) {
            return this;
        }
        Stats stats = tableStats.getStats(this.relation.relationName());
        return new Collect(this.preferSourceLookup, this.relation, newOutputs, this.where, this.numExpectedRows, stats.estimateSizeForColumns(newOutputs));
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(TableStats tableStats, Collection<Symbol> usedColumns) {
        if (!(this.tableInfo instanceof DocTableInfo)) {
            return null;
        }
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        LinkedHashMap<Symbol, Symbol> replacedOutputs = new LinkedHashMap<Symbol, Symbol>();
        ArrayList<Reference> refsToFetch = new ArrayList<Reference>();
        FetchMarker fetchMarker = new FetchMarker(this.relation.relationName(), refsToFetch);
        for (int i = 0; i < this.outputs.size(); ++i) {
            Symbol output = this.outputs.get(i);
            if (Symbols.containsColumn(output, DocSysColumns.SCORE)) {
                newOutputs.add(output);
                replacedOutputs.put(output, output);
                continue;
            }
            if (!SymbolVisitors.any(Symbols.IS_COLUMN, output)) {
                newOutputs.add(output);
                replacedOutputs.put(output, output);
                continue;
            }
            if (SymbolVisitors.any(usedColumns::contains, output)) {
                newOutputs.add(output);
                replacedOutputs.put(output, output);
                continue;
            }
            Symbol outputWithFetchStub = RefReplacer.replaceRefs(output, ref -> {
                Reference sourceLookup = DocReferences.toSourceLookup(ref);
                refsToFetch.add(sourceLookup);
                return new FetchStub(fetchMarker, sourceLookup);
            });
            replacedOutputs.put(output, outputWithFetchStub);
        }
        if (newOutputs.size() == this.outputs.size()) {
            return null;
        }
        newOutputs.add(0, fetchMarker);
        Stats stats = tableStats.getStats(this.relation.relationName());
        return new FetchRewrite(replacedOutputs, new Collect(this.preferSourceLookup, this.relation, newOutputs, this.where, this.numExpectedRows, stats.estimateSizeForColumns(newOutputs)));
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    @Override
    public long numExpectedRows() {
        return this.numExpectedRows;
    }

    @Override
    public long estimatedRowSize() {
        return this.estimatedRowSize;
    }

    public String toString() {
        return "Collect{" + this.tableInfo.ident() + ", [" + Lists2.joinOn(", ", this.outputs, Symbol::toString) + "], " + this.where + "}";
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitCollect(this, context);
    }

    public boolean preferSourceLookup() {
        return this.preferSourceLookup;
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("Collect[").text(this.tableInfo.ident().toString()).text(" | [").text(Lists2.joinOn(", ", this.outputs, Symbol::toString)).text("] | ").text(this.where.queryOrFallback().toString()).text("]");
    }
}

