/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.management;

import io.crate.action.sql.BaseResultReceiver;
import io.crate.action.sql.RowConsumerToResultReceiver;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.MapBuilder;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.dsl.phases.NodeOperationGrouper;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.engine.profile.TransportCollectProfileNodeAction;
import io.crate.execution.engine.profile.TransportCollectProfileOperation;
import io.crate.execution.support.OneRowActionListener;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Plan;
import io.crate.planner.PlanPrinter;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.statement.CopyFromPlan;
import io.crate.profile.ProfilingContext;
import io.crate.profile.Timer;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class ExplainPlan
implements Plan {
    private final Plan subPlan;
    @Nullable
    private final ProfilingContext context;

    public ExplainPlan(Plan subExecutionPlan, @Nullable ProfilingContext context) {
        this.subPlan = subExecutionPlan;
        this.context = context;
    }

    public Plan subPlan() {
        return this.subPlan;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        if (this.context != null) {
            assert (this.subPlan instanceof LogicalPlan) : "subPlan must be a LogicalPlan";
            LogicalPlan plan = (LogicalPlan)this.subPlan;
            if (plan.dependencies().isEmpty()) {
                UUID jobId = plannerContext.jobId();
                BaseResultReceiver resultReceiver = new BaseResultReceiver();
                RowConsumerToResultReceiver noopRowConsumer = new RowConsumerToResultReceiver(resultReceiver, 0, t -> {});
                Timer timer = this.context.createTimer(Phase.Execute.name());
                timer.start();
                NodeOperationTree operationTree = LogicalPlanner.getNodeOperationTree(plan, dependencies, plannerContext, params, subQueryResults);
                resultReceiver.completionFuture().whenComplete((BiConsumer)this.createResultConsumer(dependencies, consumer, jobId, timer, operationTree));
                LogicalPlanner.executeNodeOpTree(dependencies, plannerContext.transactionContext(), jobId, noopRowConsumer, true, operationTree);
            } else {
                consumer.accept(null, new UnsupportedOperationException("EXPLAIN ANALYZE does not support profiling multi-phase plans, such as queries with scalar subselects."));
            }
        } else if (this.subPlan instanceof LogicalPlan) {
            PrintContext printContext = new PrintContext();
            ((LogicalPlan)this.subPlan).print(printContext);
            consumer.accept(InMemoryBatchIterator.of(new Row1(printContext.toString()), SentinelRow.SENTINEL), null);
        } else if (this.subPlan instanceof CopyFromPlan) {
            ExecutionPlan executionPlan = CopyFromPlan.planCopyFromExecution(((CopyFromPlan)this.subPlan).copyFrom(), dependencies.clusterService().state().nodes(), plannerContext, params, subQueryResults);
            String planAsJson = DataTypes.STRING.implicitCast(PlanPrinter.objectMap(executionPlan));
            consumer.accept(InMemoryBatchIterator.of(new Row1(planAsJson), SentinelRow.SENTINEL), null);
        } else {
            consumer.accept(InMemoryBatchIterator.of(new Row1("EXPLAIN not supported for " + this.subPlan.getClass().getSimpleName()), SentinelRow.SENTINEL), null);
        }
    }

    private BiConsumer<Void, Throwable> createResultConsumer(DependencyCarrier executor, RowConsumer consumer, UUID jobId, Timer timer, NodeOperationTree operationTree) {
        assert (this.context != null) : "profilingContext must be available if createResultconsumer is used";
        return (ignored, t) -> {
            this.context.stopTimerAndStoreDuration(timer);
            if (t == null) {
                OneRowActionListener<Map> actionListener = new OneRowActionListener<Map>(consumer, resp -> this.buildResponse(this.context.getDurationInMSByTimer(), (Map<String, Map<String, Object>>)resp, operationTree));
                this.collectTimingResults(jobId, executor, operationTree.nodeOperations()).whenComplete(actionListener);
            } else {
                consumer.accept(null, (Throwable)t);
            }
        };
    }

    private TransportCollectProfileOperation getRemoteCollectOperation(DependencyCarrier executor, UUID jobId) {
        TransportCollectProfileNodeAction nodeAction = executor.transportActionProvider().transportCollectProfileNodeAction();
        return new TransportCollectProfileOperation(nodeAction, jobId);
    }

    private Row buildResponse(Map<String, Object> apeTimings, Map<String, Map<String, Object>> timingsByNodeId, NodeOperationTree operationTree) {
        MapBuilder mapBuilder = MapBuilder.newMapBuilder();
        apeTimings.forEach(mapBuilder::put);
        Map<String, Object> phasesTimings = ExplainPlan.extractPhasesTimingsFrom(timingsByNodeId, operationTree);
        Map<String, Map<String, Object>> resultNodeTimings = ExplainPlan.getNodeTimingsWithoutPhases(phasesTimings.keySet(), timingsByNodeId);
        MapBuilder<String, Object> executionTimingsMap = MapBuilder.newMapBuilder();
        executionTimingsMap.put("Phases", phasesTimings);
        resultNodeTimings.forEach(executionTimingsMap::put);
        executionTimingsMap.put("Total", apeTimings.get(Phase.Execute.name()));
        mapBuilder.put(Phase.Execute.name(), executionTimingsMap.immutableMap());
        return new Row1(mapBuilder.immutableMap());
    }

    private static Map<String, Object> extractPhasesTimingsFrom(Map<String, Map<String, Object>> timingsByNodeId, NodeOperationTree operationTree) {
        TreeMap<String, Object> allPhases = new TreeMap<String, Object>();
        for (NodeOperation operation : operationTree.nodeOperations()) {
            ExecutionPhase phase = operation.executionPhase();
            ExplainPlan.getPhaseTimingsAndAddThemToPhasesMap(phase, timingsByNodeId, allPhases);
        }
        ExecutionPhase leafExecutionPhase = operationTree.leaf();
        ExplainPlan.getPhaseTimingsAndAddThemToPhasesMap(leafExecutionPhase, timingsByNodeId, allPhases);
        return allPhases;
    }

    private static void getPhaseTimingsAndAddThemToPhasesMap(ExecutionPhase leafExecutionPhase, Map<String, Map<String, Object>> timingsByNodeId, Map<String, Object> allPhases) {
        String phaseName = ProfilingContext.generateProfilingKey(leafExecutionPhase.phaseId(), leafExecutionPhase.name());
        Map<String, Object> phaseTimingsAcrossNodes = ExplainPlan.getPhaseTimingsAcrossNodes(phaseName, timingsByNodeId);
        if (!phaseTimingsAcrossNodes.isEmpty()) {
            allPhases.put(phaseName, Map.of("nodes", phaseTimingsAcrossNodes));
        }
    }

    private static Map<String, Object> getPhaseTimingsAcrossNodes(String phaseName, Map<String, Map<String, Object>> timingsByNodeId) {
        HashMap<String, Object> timingsForPhaseAcrossNodes = new HashMap<String, Object>();
        for (Map.Entry<String, Map<String, Object>> nodeToTimingsEntry : timingsByNodeId.entrySet()) {
            Object phaseTiming;
            Map<String, Object> timingsForNode = nodeToTimingsEntry.getValue();
            if (timingsForNode == null || (phaseTiming = timingsForNode.get(phaseName)) == null) continue;
            String node = nodeToTimingsEntry.getKey();
            timingsForPhaseAcrossNodes.put(node, phaseTiming);
        }
        return Collections.unmodifiableMap(timingsForPhaseAcrossNodes);
    }

    private static Map<String, Map<String, Object>> getNodeTimingsWithoutPhases(Set<String> phasesNames, Map<String, Map<String, Object>> timingsByNodeId) {
        HashMap<String, HashMap<String, Object>> nodeTimingsWithoutPhases = new HashMap<String, HashMap<String, Object>>(timingsByNodeId.size());
        for (Map.Entry<String, Map<String, Object>> nodeToTimingsEntry : timingsByNodeId.entrySet()) {
            nodeTimingsWithoutPhases.put(nodeToTimingsEntry.getKey(), new HashMap<String, Object>(nodeToTimingsEntry.getValue()));
        }
        for (Map timings : nodeTimingsWithoutPhases.values()) {
            for (String phaseToRemove : phasesNames) {
                timings.remove(phaseToRemove);
            }
        }
        return Collections.unmodifiableMap(nodeTimingsWithoutPhases);
    }

    private CompletableFuture<Map<String, Map<String, Object>>> collectTimingResults(UUID jobId, DependencyCarrier executor, Collection<NodeOperation> nodeOperations) {
        Set<String> nodeIds = NodeOperationGrouper.groupByServer(nodeOperations).keySet();
        CompletableFuture<Map<String, Map<String, Object>>> resultFuture = new CompletableFuture<Map<String, Map<String, Object>>>();
        TransportCollectProfileOperation remoteCollectOperation = this.getRemoteCollectOperation(executor, jobId);
        ConcurrentHashMap<String, Map<String, Object>> timingsByNodeId = new ConcurrentHashMap<String, Map<String, Object>>(nodeIds.size());
        boolean needsCollectLocal = !nodeIds.contains(executor.localNodeId());
        AtomicInteger remainingCollectOps = new AtomicInteger(nodeIds.size());
        if (needsCollectLocal) {
            remainingCollectOps.incrementAndGet();
        }
        for (String nodeId : nodeIds) {
            remoteCollectOperation.collect(nodeId).whenComplete((BiConsumer)ExplainPlan.mergeResultsAndCompleteFuture(resultFuture, timingsByNodeId, remainingCollectOps, nodeId));
        }
        if (needsCollectLocal) {
            executor.transportActionProvider().transportCollectProfileNodeAction().collectExecutionTimesAndFinishContext(jobId).whenComplete((BiConsumer)ExplainPlan.mergeResultsAndCompleteFuture(resultFuture, timingsByNodeId, remainingCollectOps, executor.localNodeId()));
        }
        return resultFuture;
    }

    private static BiConsumer<Map<String, Object>, Throwable> mergeResultsAndCompleteFuture(CompletableFuture<Map<String, Map<String, Object>>> resultFuture, ConcurrentHashMap<String, Map<String, Object>> timingsByNodeId, AtomicInteger remainingOperations, String nodeId) {
        return (map, throwable) -> {
            if (throwable == null) {
                timingsByNodeId.put(nodeId, (Map<String, Object>)map);
                if (remainingOperations.decrementAndGet() == 0) {
                    resultFuture.complete(timingsByNodeId);
                }
            } else {
                resultFuture.completeExceptionally((Throwable)throwable);
            }
        };
    }

    @VisibleForTesting
    public boolean doAnalyze() {
        return this.context != null;
    }

    public static enum Phase {
        Analyze,
        Plan,
        Execute;

    }
}

