/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.dql.join;

public enum JoinType {
    CROSS,
    INNER,
    LEFT{

        @Override
        public JoinType invert() {
            return RIGHT;
        }
    }
    ,
    RIGHT{

        @Override
        public JoinType invert() {
            return LEFT;
        }
    }
    ,
    FULL,
    SEMI{

        @Override
        public JoinType invert() {
            throw new UnsupportedOperationException("Tables of a SEMI Join cannot be inverted");
        }

        @Override
        public boolean supportsInversion() {
            return false;
        }
    }
    ,
    ANTI{

        @Override
        public JoinType invert() {
            throw new UnsupportedOperationException("Tables of a ANTI Join cannot be inverted");
        }

        @Override
        public boolean supportsInversion() {
            return false;
        }
    };


    public JoinType invert() {
        return this;
    }

    public boolean supportsInversion() {
        return true;
    }

    public boolean isOuter() {
        return this.ordinal() > INNER.ordinal() && this.ordinal() <= FULL.ordinal();
    }
}

