/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.dql.join;

import io.crate.execution.dsl.phases.JoinPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.ExecutionPlanVisitor;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.types.DataType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class Join
implements ExecutionPlan,
ResultDescription {
    private final ExecutionPlan left;
    private final ExecutionPlan right;
    private final JoinPhase joinPhase;
    private int limit;
    private int offset;
    private int numOutputs;
    private final int maxRowsPerNode;
    @Nullable
    private PositionalOrderBy orderBy;

    public Join(JoinPhase joinPhase, ExecutionPlan left, ExecutionPlan right, int limit, int offset, int maxRowsPerNode, int numOutputs, @Nullable PositionalOrderBy orderBy) {
        this.left = left;
        this.right = right;
        this.joinPhase = joinPhase;
        this.limit = limit;
        this.offset = offset;
        this.maxRowsPerNode = maxRowsPerNode;
        this.orderBy = orderBy;
        this.numOutputs = numOutputs;
    }

    public ExecutionPlan left() {
        return this.left;
    }

    public ExecutionPlan right() {
        return this.right;
    }

    public JoinPhase joinPhase() {
        return this.joinPhase;
    }

    @Override
    public ResultDescription resultDescription() {
        return this;
    }

    @Override
    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this.joinPhase.distributionInfo(distributionInfo);
    }

    @Override
    public <C, R> R accept(ExecutionPlanVisitor<C, R> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    @Override
    public void addProjection(Projection projection) {
        this.joinPhase.addProjection(projection);
        this.numOutputs = projection.outputs().size();
    }

    @Override
    public void addProjection(Projection projection, int unfinishedLimit, int unfinishedOffset, @Nullable PositionalOrderBy unfinishedOrderBy) {
        this.joinPhase.addProjection(projection);
        this.limit = unfinishedLimit;
        this.offset = unfinishedOffset;
        this.orderBy = unfinishedOrderBy;
        this.numOutputs = projection.outputs().size();
    }

    @Override
    public Collection<String> nodeIds() {
        return this.joinPhase.nodeIds();
    }

    @Override
    @Nullable
    public PositionalOrderBy orderBy() {
        return this.orderBy;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public int maxRowsPerNode() {
        return this.maxRowsPerNode;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int numOutputs() {
        return this.numOutputs;
    }

    @Override
    public List<DataType<?>> streamOutputs() {
        return this.joinPhase.outputTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Join join = (Join)o;
        return this.limit == join.limit && this.offset == join.offset && this.numOutputs == join.numOutputs && this.maxRowsPerNode == join.maxRowsPerNode && Objects.equals(this.left, join.left) && Objects.equals(this.right, join.right) && Objects.equals(this.joinPhase, join.joinPhase) && Objects.equals(this.orderBy, join.orderBy);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right, this.joinPhase, this.limit, this.offset, this.numOutputs, this.maxRowsPerNode, this.orderBy);
    }
}

