/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.dml;

import io.crate.analyze.where.DocKeys;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dml.ShardRequestExecutor;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.expression.symbol.Assignments;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.shard.ShardId;

public final class UpdateById
implements Plan {
    private final DocTableInfo table;
    private final Map<Reference, Symbol> assignmentByTargetCol;
    private final DocKeys docKeys;
    private final Assignments assignments;
    @Nullable
    private final Symbol[] returnValues;

    public UpdateById(DocTableInfo table, Map<Reference, Symbol> assignmentByTargetCol, DocKeys docKeys, @Nullable List<Symbol> returnValues, NodeContext nodeCtx) {
        this.table = table;
        this.assignments = Assignments.convert(assignmentByTargetCol, nodeCtx);
        this.assignmentByTargetCol = assignmentByTargetCol;
        this.docKeys = docKeys;
        this.returnValues = returnValues == null ? null : returnValues.toArray(new Symbol[0]);
    }

    @VisibleForTesting
    public Map<Reference, Symbol> assignmentByTargetCol() {
        return this.assignmentByTargetCol;
    }

    @VisibleForTesting
    public DocKeys docKeys() {
        return this.docKeys;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.UPDATE;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        ShardRequestExecutor<ShardUpsertRequest> executor = this.createExecutor(dependencies, plannerContext);
        if (this.returnValues == null) {
            executor.execute(consumer, params, subQueryResults);
        } else {
            executor.executeCollectValues(consumer, params, subQueryResults);
        }
    }

    @Override
    public List<CompletableFuture<Long>> executeBulk(DependencyCarrier dependencies, PlannerContext plannerContext, List<Row> bulkParams, SubQueryResults subQueryResults) {
        return this.createExecutor(dependencies, plannerContext).executeBulk(bulkParams, subQueryResults);
    }

    private ShardRequestExecutor<ShardUpsertRequest> createExecutor(DependencyCarrier dependencies, PlannerContext plannerContext) {
        ClusterService clusterService = dependencies.clusterService();
        CoordinatorTxnCtx txnCtx = plannerContext.transactionContext();
        ShardUpsertRequest.Builder requestBuilder = new ShardUpsertRequest.Builder(txnCtx.sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.setting().get(clusterService.state().metadata().settings()), ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, true, this.assignments.targetNames(), null, this.returnValues, plannerContext.jobId(), false);
        UpdateRequests updateRequests = new UpdateRequests(requestBuilder, this.table, this.assignments);
        return new ShardRequestExecutor<ShardUpsertRequest>(clusterService, txnCtx, dependencies.nodeContext(), this.table, updateRequests, dependencies.transportActionProvider().transportShardUpsertAction()::execute, this.docKeys);
    }

    private static class UpdateRequests
    implements ShardRequestExecutor.RequestGrouper<ShardUpsertRequest> {
        private final ShardUpsertRequest.Builder requestBuilder;
        private final DocTableInfo table;
        private final Assignments assignments;
        private Symbol[] assignmentSources;

        UpdateRequests(ShardUpsertRequest.Builder requestBuilder, DocTableInfo table, Assignments assignments) {
            this.requestBuilder = requestBuilder;
            this.table = table;
            this.assignments = assignments;
        }

        @Override
        public ShardUpsertRequest newRequest(ShardId shardId) {
            return this.requestBuilder.newRequest(shardId);
        }

        @Override
        public void bind(Row parameters, SubQueryResults subQueryResults) {
            this.assignmentSources = this.assignments.bindSources(this.table, parameters, subQueryResults);
        }

        @Override
        public void addItem(ShardUpsertRequest request, int location, String id, Long version, Long seqNo, Long primaryTerm) {
            ShardUpsertRequest.Item item = new ShardUpsertRequest.Item(id, this.assignmentSources, null, version, seqNo, primaryTerm);
            request.add(location, item);
        }
    }
}

