/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.dml;

import io.crate.analyze.where.DocKeys;
import io.crate.common.unit.TimeValue;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dml.ShardRequestExecutor;
import io.crate.execution.dml.delete.ShardDeleteRequest;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.shard.ShardId;

public class DeleteById
implements Plan {
    private final DocTableInfo table;
    private final DocKeys docKeys;

    public DeleteById(DocTableInfo table, DocKeys docKeys) {
        this.table = table;
        this.docKeys = docKeys;
    }

    public DocTableInfo table() {
        return this.table;
    }

    public DocKeys docKeys() {
        return this.docKeys;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DELETE;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        this.createExecutor(dependencies, plannerContext).execute(consumer, params, subQueryResults);
    }

    @Override
    public List<CompletableFuture<Long>> executeBulk(DependencyCarrier dependencies, PlannerContext plannerContext, List<Row> bulkParams, SubQueryResults subQueryResults) {
        return this.createExecutor(dependencies, plannerContext).executeBulk(bulkParams, subQueryResults);
    }

    private ShardRequestExecutor<ShardDeleteRequest> createExecutor(DependencyCarrier dependencies, PlannerContext plannerContext) {
        ClusterService clusterService = dependencies.clusterService();
        TimeValue requestTimeout = ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.setting().get(clusterService.state().metadata().settings());
        return new ShardRequestExecutor<ShardDeleteRequest>(clusterService, plannerContext.transactionContext(), dependencies.nodeContext(), this.table, new DeleteRequests(plannerContext.jobId(), requestTimeout), dependencies.transportActionProvider().transportShardDeleteAction()::execute, this.docKeys);
    }

    static class DeleteRequests
    implements ShardRequestExecutor.RequestGrouper<ShardDeleteRequest> {
        private final UUID jobId;
        private final TimeValue requestTimeout;

        DeleteRequests(UUID jobId, TimeValue requestTimeout) {
            this.jobId = jobId;
            this.requestTimeout = requestTimeout;
        }

        @Override
        public ShardDeleteRequest newRequest(ShardId shardId) {
            ShardDeleteRequest request = new ShardDeleteRequest(shardId, this.jobId);
            request.timeout(this.requestTimeout);
            return request;
        }

        @Override
        public void bind(Row parameters, SubQueryResults subQueryResults) {
        }

        @Override
        public void addItem(ShardDeleteRequest request, int location, String id, Long version, Long seqNo, Long primaryTerm) {
            ShardDeleteRequest.Item item = new ShardDeleteRequest.Item(id);
            if (version != null) {
                item.version(version);
            }
            if (seqNo != null) {
                item.seqNo(seqNo);
            }
            if (primaryTerm != null) {
                item.primaryTerm(primaryTerm);
            }
            request.add(location, item);
        }
    }
}

