/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.action.FutureActionListener;
import io.crate.analyze.AnalyzedRestoreSnapshot;
import io.crate.analyze.BoundRestoreSnapshot;
import io.crate.analyze.GenericPropertiesConverter;
import io.crate.analyze.PartitionPropertiesAnalyzer;
import io.crate.analyze.SnapshotSettings;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.exceptions.PartitionAlreadyExistsException;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.TransportGetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.SnapshotInfo;

public class RestoreSnapshotPlan
implements Plan {
    private static final String ALL_TEMPLATES = "_all";
    private final AnalyzedRestoreSnapshot restoreSnapshot;

    public RestoreSnapshotPlan(AnalyzedRestoreSnapshot restoreSnapshot) {
        this.restoreSnapshot = restoreSnapshot;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        BoundRestoreSnapshot stmt = RestoreSnapshotPlan.bind(this.restoreSnapshot, plannerContext.transactionContext(), dependencies.nodeContext(), parameters, subQueryResults, dependencies.schemas());
        Settings settings = stmt.settings();
        boolean ignoreUnavailable = SnapshotSettings.IGNORE_UNAVAILABLE.get(settings);
        TransportActionProvider transportActionProvider = dependencies.transportActionProvider();
        RestoreSnapshotPlan.resolveIndexNames(this.restoreSnapshot.repository(), stmt.restoreTables(), ignoreUnavailable, transportActionProvider.transportGetSnapshotsAction()).whenComplete((ctx, t) -> {
            if (t == null) {
                String[] stringArray;
                String[] indexNames = ctx.resolvedIndices().toArray(new String[0]);
                if (stmt.restoreTables().isEmpty()) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ALL_TEMPLATES;
                } else {
                    stringArray = ctx.resolvedTemplates().toArray(new String[0]);
                }
                String[] templateNames = stringArray;
                IndicesOptions indicesOptions = IndicesOptions.fromOptions(ignoreUnavailable, true, true, false, IndicesOptions.lenientExpandOpen());
                RestoreSnapshotRequest request = new RestoreSnapshotRequest(this.restoreSnapshot.repository(), this.restoreSnapshot.snapshot()).indices(indexNames).templates(templateNames).indicesOptions(indicesOptions).settings(settings).waitForCompletion(SnapshotSettings.WAIT_FOR_COMPLETION.get(settings)).includeGlobalState(false).includeAliases(true);
                transportActionProvider.transportRestoreSnapshotAction().execute(request, new OneRowActionListener<RestoreSnapshotResponse>(consumer, r -> new Row1(r == null ? -1L : 1L)));
            }
        });
    }

    @VisibleForTesting
    public static BoundRestoreSnapshot bind(AnalyzedRestoreSnapshot restoreSnapshot, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults, Schemas schemas) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        Settings settings = GenericPropertiesConverter.genericPropertiesToSettings(restoreSnapshot.properties().map(eval), SnapshotSettings.SETTINGS);
        HashSet<BoundRestoreSnapshot.RestoreTableInfo> restoreTables = new HashSet<BoundRestoreSnapshot.RestoreTableInfo>(restoreSnapshot.tables().size());
        for (Table<Symbol> table : restoreSnapshot.tables()) {
            PartitionName partitionName;
            RelationName relationName = RelationName.of(table.getName(), txnCtx.sessionContext().searchPath().currentSchema());
            try {
                DocTableInfo docTableInfo = (DocTableInfo)schemas.getTableInfo(relationName, Operation.RESTORE_SNAPSHOT);
                if (table.partitionProperties().isEmpty()) {
                    throw new RelationAlreadyExists(relationName);
                }
                partitionName = PartitionPropertiesAnalyzer.toPartitionName(docTableInfo, Lists2.map(table.partitionProperties(), x -> x.map(eval)));
                if (docTableInfo.partitions().contains(partitionName)) {
                    throw new PartitionAlreadyExistsException(partitionName);
                }
                restoreTables.add(new BoundRestoreSnapshot.RestoreTableInfo(relationName, partitionName));
            }
            catch (RelationUnknown | SchemaUnknownException e) {
                if (table.partitionProperties().isEmpty()) {
                    restoreTables.add(new BoundRestoreSnapshot.RestoreTableInfo(relationName, null));
                    continue;
                }
                partitionName = PartitionPropertiesAnalyzer.toPartitionName(relationName, Lists2.map(table.partitionProperties(), x -> x.map(eval)));
                restoreTables.add(new BoundRestoreSnapshot.RestoreTableInfo(relationName, partitionName));
            }
        }
        return new BoundRestoreSnapshot(restoreSnapshot.repository(), restoreSnapshot.snapshot(), restoreTables, settings);
    }

    @VisibleForTesting
    static CompletableFuture<ResolveIndicesAndTemplatesContext> resolveIndexNames(String repositoryName, Set<BoundRestoreSnapshot.RestoreTableInfo> restoreTables, boolean ignoreUnavailable, TransportGetSnapshotsAction transportGetSnapshotsAction) {
        ResolveIndicesAndTemplatesContext context = new ResolveIndicesAndTemplatesContext();
        ArrayList<BoundRestoreSnapshot.RestoreTableInfo> toResolveFromSnapshot = new ArrayList<BoundRestoreSnapshot.RestoreTableInfo>();
        for (BoundRestoreSnapshot.RestoreTableInfo table : restoreTables) {
            if (table.hasPartitionInfo()) {
                context.addIndex(table.partitionName().asIndexName());
                context.addTemplate(table.partitionTemplate());
                continue;
            }
            if (ignoreUnavailable) {
                context.addIndex(table.tableIdent().indexNameOrAlias());
                String templateName = table.partitionTemplate();
                context.addIndex(templateName + "*");
                context.addTemplate(templateName);
                continue;
            }
            toResolveFromSnapshot.add(table);
        }
        if (toResolveFromSnapshot.isEmpty()) {
            return CompletableFuture.completedFuture(context);
        }
        FutureActionListener<GetSnapshotsResponse, ResolveIndicesAndTemplatesContext> listener = new FutureActionListener<GetSnapshotsResponse, ResolveIndicesAndTemplatesContext>(response -> {
            RestoreSnapshotPlan.resolveTablesFromSnapshots(toResolveFromSnapshot, response.getSnapshots(), context);
            return context;
        });
        transportGetSnapshotsAction.execute(new GetSnapshotsRequest(repositoryName), listener);
        return listener;
    }

    @VisibleForTesting
    static void resolveTablesFromSnapshots(List<BoundRestoreSnapshot.RestoreTableInfo> toResolveFromSnapshot, List<SnapshotInfo> snapshots, ResolveIndicesAndTemplatesContext context) throws RelationUnknown {
        for (BoundRestoreSnapshot.RestoreTableInfo table : toResolveFromSnapshot) {
            RestoreSnapshotPlan.resolveTableFromSnapshots(table, snapshots, context);
        }
    }

    @VisibleForTesting
    static void resolveTableFromSnapshots(BoundRestoreSnapshot.RestoreTableInfo table, List<SnapshotInfo> snapshots, ResolveIndicesAndTemplatesContext context) throws RelationUnknown {
        String name = table.tableIdent().indexNameOrAlias();
        for (SnapshotInfo snapshot : snapshots) {
            for (String index : snapshot.indices()) {
                if (name.equals(index)) {
                    context.addIndex(index);
                    return;
                }
                if (!RestoreSnapshotPlan.isIndexPartitionOfTable(index, table.tableIdent())) continue;
                String templateName = table.partitionTemplate();
                context.addIndex(templateName + "*");
                context.addTemplate(templateName);
                return;
            }
        }
        context.addTemplate(table.partitionTemplate());
    }

    private static boolean isIndexPartitionOfTable(String index, RelationName relationName) {
        return IndexParts.isPartitioned(index) && PartitionName.fromIndexOrTemplate(index).relationName().equals(relationName);
    }

    @VisibleForTesting
    static class ResolveIndicesAndTemplatesContext {
        private final HashSet<String> resolvedIndices = new HashSet();
        private final HashSet<String> resolvedTemplates = new HashSet();

        ResolveIndicesAndTemplatesContext() {
        }

        void addIndex(String index) {
            this.resolvedIndices.add(index);
        }

        void addTemplate(String template) {
            this.resolvedTemplates.add(template);
        }

        HashSet<String> resolvedIndices() {
            return this.resolvedIndices;
        }

        HashSet<String> resolvedTemplates() {
            return this.resolvedTemplates;
        }
    }
}

