/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedRefreshTable;
import io.crate.analyze.PartitionPropertiesAnalyzer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists2;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.exceptions.PartitionUnknownException;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.PartitionName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.refresh.TransportRefreshAction;
import org.elasticsearch.action.support.IndicesOptions;

public class RefreshTablePlan
implements Plan {
    private final AnalyzedRefreshTable analysis;

    public RefreshTablePlan(AnalyzedRefreshTable analysis) {
        this.analysis = analysis;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        if (this.analysis.tables().isEmpty()) {
            consumer.accept(InMemoryBatchIterator.empty(SentinelRow.SENTINEL), null);
            return;
        }
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, parameters, subQueryResults);
        ArrayList<String> toRefresh = new ArrayList<String>();
        for (Map.Entry<Table<Symbol>, DocTableInfo> table : this.analysis.tables().entrySet()) {
            DocTableInfo tableInfo = table.getValue();
            Table<Symbol> tableSymbol = table.getKey();
            if (tableSymbol.partitionProperties().isEmpty()) {
                toRefresh.addAll(Arrays.asList(tableInfo.concreteOpenIndices()));
                continue;
            }
            PartitionName partitionName = PartitionPropertiesAnalyzer.toPartitionName(tableInfo, Lists2.map(tableSymbol.partitionProperties(), p -> p.map(eval)));
            if (!tableInfo.partitions().contains(partitionName)) {
                throw new PartitionUnknownException(partitionName);
            }
            toRefresh.add(partitionName.asIndexName());
        }
        RefreshRequest request = new RefreshRequest((String[])toRefresh.toArray(String[]::new));
        request.indicesOptions(IndicesOptions.lenientExpandOpen());
        TransportRefreshAction transportRefreshAction = dependencies.transportActionProvider().transportRefreshAction();
        transportRefreshAction.execute(request, new OneRowActionListener<RefreshResponse>(consumer, response -> new Row1(toRefresh.isEmpty() ? -1L : (long)toRefresh.size())));
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }
}

