/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedOptimizeTable;
import io.crate.analyze.GenericPropertiesConverter;
import io.crate.analyze.OptimizeTableSettings;
import io.crate.analyze.PartitionPropertiesAnalyzer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.exceptions.PartitionUnknownException;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.forcemerge.TransportForceMergeAction;
import org.elasticsearch.action.admin.indices.upgrade.post.TransportUpgradeAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.settings.Settings;

public class OptimizeTablePlan
implements Plan {
    private final AnalyzedOptimizeTable optimizeTable;

    public OptimizeTablePlan(AnalyzedOptimizeTable optimizeTable) {
        this.optimizeTable = optimizeTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        if (this.optimizeTable.tables().isEmpty()) {
            consumer.accept(InMemoryBatchIterator.empty(SentinelRow.SENTINEL), null);
            return;
        }
        BoundOptimizeTable stmt = OptimizeTablePlan.bind(this.optimizeTable, plannerContext.transactionContext(), dependencies.nodeContext(), parameters, subQueryResults);
        Settings settings = stmt.settings();
        List<String> toOptimize = stmt.indexNames();
        if (OptimizeTableSettings.UPGRADE_SEGMENTS.get(settings).booleanValue()) {
            UpgradeRequest request = new UpgradeRequest(toOptimize.toArray(new String[0]));
            TransportUpgradeAction transportUpgradeAction = dependencies.transportActionProvider().transportUpgradeAction();
            transportUpgradeAction.execute(request, new OneRowActionListener<UpgradeResponse>(consumer, response -> new Row1(toOptimize.isEmpty() ? -1L : (long)toOptimize.size())));
        } else {
            ForceMergeRequest request = new ForceMergeRequest(toOptimize.toArray(new String[0]));
            request.maxNumSegments(OptimizeTableSettings.MAX_NUM_SEGMENTS.get(settings));
            request.onlyExpungeDeletes(OptimizeTableSettings.ONLY_EXPUNGE_DELETES.get(settings));
            request.flush(OptimizeTableSettings.FLUSH.get(settings));
            request.indicesOptions(IndicesOptions.lenientExpandOpen());
            TransportForceMergeAction transportForceMergeAction = dependencies.transportActionProvider().transportForceMergeAction();
            transportForceMergeAction.execute(request, new OneRowActionListener<ForceMergeResponse>(consumer, response -> new Row1(toOptimize.isEmpty() ? -1L : (long)toOptimize.size())));
        }
    }

    @VisibleForTesting
    public static BoundOptimizeTable bind(AnalyzedOptimizeTable optimizeTable, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        GenericProperties<Object> genericProperties = optimizeTable.properties().map(eval);
        Settings settings = GenericPropertiesConverter.genericPropertiesToSettings(genericProperties, OptimizeTableSettings.SUPPORTED_SETTINGS);
        OptimizeTablePlan.validateSettings(settings, genericProperties);
        ArrayList<String> toOptimize = new ArrayList<String>();
        for (Map.Entry<Table<Symbol>, TableInfo> table : optimizeTable.tables().entrySet()) {
            TableInfo tableInfo = table.getValue();
            Table<Symbol> tableSymbol = table.getKey();
            if (tableInfo instanceof BlobTableInfo) {
                toOptimize.add(((BlobTableInfo)tableInfo).concreteIndices()[0]);
                continue;
            }
            DocTableInfo docTableInfo = (DocTableInfo)tableInfo;
            if (tableSymbol.partitionProperties().isEmpty()) {
                toOptimize.addAll(Arrays.asList(docTableInfo.concreteOpenIndices()));
                continue;
            }
            PartitionName partitionName = PartitionPropertiesAnalyzer.toPartitionName(docTableInfo, Lists2.map(tableSymbol.partitionProperties(), x -> x.map(eval)));
            if (!docTableInfo.partitions().contains(partitionName)) {
                throw new PartitionUnknownException(partitionName);
            }
            toOptimize.add(partitionName.asIndexName());
        }
        return new BoundOptimizeTable(toOptimize, settings);
    }

    private static void validateSettings(Settings settings, GenericProperties properties) {
        if (OptimizeTableSettings.UPGRADE_SEGMENTS.get(settings).booleanValue() && properties.size() > 1) {
            throw new IllegalArgumentException("cannot use other parameters if " + OptimizeTableSettings.UPGRADE_SEGMENTS.getKey() + " is set to true");
        }
    }

    public static class BoundOptimizeTable {
        private final List<String> indexNames;
        private final Settings settings;

        BoundOptimizeTable(List<String> indexNames, Settings settings) {
            this.indexNames = indexNames;
            this.settings = settings;
        }

        public List<String> indexNames() {
            return this.indexNames;
        }

        public Settings settings() {
            return this.settings;
        }
    }
}

