/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedDropTable;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.ddl.tables.DropTableRequest;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.index.IndexNotFoundException;

public class DropTablePlan
implements Plan {
    private static final Logger LOGGER = LogManager.getLogger(DropTablePlan.class);
    private static final Row ROW_ZERO = new Row1(0L);
    private static final Row ROW_ONE = new Row1(1L);
    private final AnalyzedDropTable<?> dropTable;

    public DropTablePlan(AnalyzedDropTable<?> dropTable) {
        this.dropTable = dropTable;
    }

    @VisibleForTesting
    public TableInfo tableInfo() {
        return this.dropTable.table();
    }

    @VisibleForTesting
    public AnalyzedDropTable<?> dropTable() {
        return this.dropTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, final RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        DropTableRequest request;
        block4: {
            Object table = this.dropTable.table();
            if (table == null) {
                if (this.dropTable.maybeCorrupt()) {
                    request = new DropTableRequest(this.dropTable.tableName(), true);
                    break block4;
                } else {
                    assert (this.dropTable.dropIfExists()) : "If table is null, IF EXISTS flag must have been present";
                    consumer.accept(InMemoryBatchIterator.of(ROW_ZERO, SentinelRow.SENTINEL), null);
                    return;
                }
            }
            boolean isPartitioned = table instanceof DocTableInfo && ((DocTableInfo)table).isPartitioned();
            request = new DropTableRequest(table.ident(), isPartitioned);
        }
        dependencies.transportDropTableAction().execute(request, new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse response) {
                if (!response.isAcknowledged() && LOGGER.isWarnEnabled() && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Dropping table {} was not acknowledged. This could lead to inconsistent state.", (Object)DropTablePlan.this.dropTable.tableName());
                }
                consumer.accept(InMemoryBatchIterator.of(ROW_ONE, SentinelRow.SENTINEL), null);
            }

            @Override
            public void onFailure(Exception e) {
                if (DropTablePlan.this.dropTable.dropIfExists() && e instanceof IndexNotFoundException) {
                    consumer.accept(InMemoryBatchIterator.of(ROW_ZERO, SentinelRow.SENTINEL), null);
                } else {
                    consumer.accept(null, e);
                }
            }
        });
    }
}

