/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.SymbolEvaluator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;

public class DeletePartitions
implements Plan {
    private final RelationName relationName;
    private final List<List<Symbol>> partitions;

    public DeletePartitions(RelationName relationName, List<List<Symbol>> partitions) {
        this.relationName = relationName;
        this.partitions = partitions;
    }

    public List<List<Symbol>> partitions() {
        return this.partitions;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DELETE;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        ArrayList<String> indexNames = this.getIndices(plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults);
        DeleteIndexRequest request = new DeleteIndexRequest(indexNames.toArray(new String[0]));
        request.indicesOptions(IndicesOptions.lenientExpandOpen());
        dependencies.transportActionProvider().transportDeleteIndexAction().execute(request, new OneRowActionListener<AcknowledgedResponse>(consumer, r -> Row1.ROW_COUNT_UNKNOWN));
    }

    @VisibleForTesting
    ArrayList<String> getIndices(TransactionContext txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults) {
        ArrayList<String> indexNames = new ArrayList<String>();
        Function<Symbol, String> symbolToString = s -> DataTypes.STRING.implicitCast(SymbolEvaluator.evaluate(txnCtx, nodeCtx, s, parameters, subQueryResults));
        for (List<Symbol> partitionValues : this.partitions) {
            List<String> values = Lists2.map(partitionValues, symbolToString);
            String indexName = IndexParts.toIndexName(this.relationName, PartitionName.encodeIdent(values));
            indexNames.add(indexName);
        }
        return indexNames;
    }
}

