/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.support.OneRowActionListener;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.List;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;

public final class DeleteAllPartitions
implements Plan {
    private final List<String> partitions;

    public DeleteAllPartitions(List<String> partitions) {
        this.partitions = partitions;
    }

    public List<String> partitions() {
        return this.partitions;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DELETE;
    }

    @Override
    public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        if (this.partitions.isEmpty()) {
            consumer.accept(InMemoryBatchIterator.of(new Row1(0L), SentinelRow.SENTINEL), null);
        } else {
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(this.partitions().toArray(new String[0])).indicesOptions(IndicesOptions.lenientExpandOpen());
            executor.transportActionProvider().transportDeleteIndexAction().execute(deleteIndexRequest, new OneRowActionListener<AcknowledgedResponse>(consumer, r -> Row1.ROW_COUNT_UNKNOWN));
        }
    }
}

